/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicLong;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;

public class AsyncRemoteAtomicLong
implements AsyncAtomicLong {
    private final AsyncNamedMap<String, AtomicLong> f_mapAtomic;
    private final String f_sName;

    protected AsyncRemoteAtomicLong(AsyncNamedMap<String, AtomicLong> mapAtomic, String sName) {
        this.f_mapAtomic = mapAtomic;
        this.f_sName = sName;
    }

    @Override
    public CompletableFuture<Long> get() {
        return this.invoke(AtomicLong::get, false);
    }

    @Override
    public CompletableFuture<Void> set(long lNewValue) {
        return this.invoke((Remote.Function & Serializable)value -> {
            value.set(lNewValue);
            return null;
        });
    }

    @Override
    public CompletableFuture<Long> getAndSet(long lNewValue) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndSet(lNewValue));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(long lExpectedValue, long lNewValue) {
        return this.invoke((Remote.Function & Serializable)value -> value.compareAndSet(lExpectedValue, lNewValue));
    }

    @Override
    public CompletableFuture<Long> getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public CompletableFuture<Long> getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    @Override
    public CompletableFuture<Long> getAndAdd(long lDelta) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndAdd(lDelta));
    }

    @Override
    public CompletableFuture<Long> incrementAndGet() {
        return this.addAndGet(1L);
    }

    @Override
    public CompletableFuture<Long> decrementAndGet() {
        return this.addAndGet(-1L);
    }

    @Override
    public CompletableFuture<Long> addAndGet(long lDelta) {
        return this.invoke((Remote.Function & Serializable)value -> value.addAndGet(lDelta));
    }

    @Override
    public CompletableFuture<Long> getAndUpdate(Remote.LongUnaryOperator updateFunction) {
        return this.getAndUpdate((LongUnaryOperator)updateFunction);
    }

    @Override
    public CompletableFuture<Long> getAndUpdate(LongUnaryOperator updateFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndUpdate(updateFunction));
    }

    @Override
    public CompletableFuture<Long> updateAndGet(Remote.LongUnaryOperator updateFunction) {
        return this.updateAndGet((LongUnaryOperator)updateFunction);
    }

    @Override
    public CompletableFuture<Long> updateAndGet(LongUnaryOperator updateFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.updateAndGet(updateFunction));
    }

    @Override
    public CompletableFuture<Long> getAndAccumulate(long lUpdate, Remote.LongBinaryOperator accumulatorFunction) {
        return this.getAndAccumulate(lUpdate, (LongBinaryOperator)accumulatorFunction);
    }

    @Override
    public CompletableFuture<Long> getAndAccumulate(long lUpdate, LongBinaryOperator accumulatorFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndAccumulate(lUpdate, accumulatorFunction));
    }

    @Override
    public CompletableFuture<Long> accumulateAndGet(long lUpdate, Remote.LongBinaryOperator accumulatorFunction) {
        return this.accumulateAndGet(lUpdate, (LongBinaryOperator)accumulatorFunction);
    }

    @Override
    public CompletableFuture<Long> accumulateAndGet(long lUpdate, LongBinaryOperator accumulatorFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.accumulateAndGet(lUpdate, accumulatorFunction));
    }

    @Override
    public CompletableFuture<Long> compareAndExchange(long lExpectedValue, long lNewValue) {
        return this.invoke((Remote.Function & Serializable)value -> value.compareAndExchange(lExpectedValue, lNewValue));
    }

    @Override
    public CompletableFuture<Integer> intValue() {
        return this.get().thenApply(Long::intValue);
    }

    @Override
    public CompletableFuture<Long> longValue() {
        return this.get();
    }

    @Override
    public CompletableFuture<Float> floatValue() {
        return this.get().thenApply(Long::floatValue);
    }

    @Override
    public CompletableFuture<Double> doubleValue() {
        return this.get().thenApply(Long::doubleValue);
    }

    @Override
    public CompletableFuture<Byte> byteValue() {
        return this.get().thenApply(Long::byteValue);
    }

    @Override
    public CompletableFuture<Short> shortValue() {
        return this.get().thenApply(Long::shortValue);
    }

    public String toString() {
        return Long.toString(this.get().join());
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicLong, R> function) {
        return this.invoke(function, true);
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicLong, R> function, boolean fMutate) {
        return this.f_mapAtomic.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
            AtomicLong value = (AtomicLong)entry.getValue();
            Object result = function.apply((Object)value);
            if (fMutate) {
                entry.setValue((Object)value);
            }
            return result;
        });
    }
}

