/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.util;

import com.tangosol.util.function.Remote;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteringIterator<T>
implements Iterator<T> {
    protected final Iterator<T> f_iterator;
    protected final Remote.Predicate<? super T> f_predicate;
    protected T m_element;

    public FilteringIterator(Iterator<T> iterator, Remote.Predicate<? super T> predicate) {
        this.f_iterator = iterator;
        this.f_predicate = predicate;
        this.m_element = null;
    }

    T findNext() {
        Object element = null;
        while (this.f_iterator != null && this.f_iterator.hasNext() && element == null) {
            element = this.f_iterator.next();
            if (this.f_predicate.test(element)) continue;
            element = null;
        }
        return element;
    }

    @Override
    public boolean hasNext() {
        if (this.m_element == null) {
            this.m_element = this.findNext();
        }
        return this.m_element != null;
    }

    @Override
    public T next() {
        if (this.m_element == null) {
            this.m_element = this.findNext();
        }
        if (this.m_element == null) {
            throw new NoSuchElementException("No further elements satisfy " + this.f_predicate);
        }
        T next = this.m_element;
        this.m_element = this.findNext();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("FilteringIterator doesn't support removal");
    }
}

