/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicInteger;
import com.tangosol.util.function.Remote;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;

public class AsyncLocalAtomicInteger
implements AsyncAtomicInteger {
    private final AtomicInteger f_nValue;

    protected AsyncLocalAtomicInteger(AtomicInteger value) {
        this.f_nValue = value;
    }

    @Override
    public CompletableFuture<Integer> get() {
        return CompletableFuture.completedFuture(this.f_nValue.get());
    }

    @Override
    public CompletableFuture<Void> set(int nNewValue) {
        this.f_nValue.set(nNewValue);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Integer> getAndSet(int nNewValue) {
        return CompletableFuture.completedFuture(this.f_nValue.getAndSet(nNewValue));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(int nExpectedValue, int nNewValue) {
        return CompletableFuture.completedFuture(this.f_nValue.compareAndSet(nExpectedValue, nNewValue));
    }

    @Override
    public CompletableFuture<Integer> getAndIncrement() {
        return this.getAndAdd(1);
    }

    @Override
    public CompletableFuture<Integer> getAndDecrement() {
        return this.getAndAdd(-1);
    }

    @Override
    public CompletableFuture<Integer> getAndAdd(int nDelta) {
        return CompletableFuture.completedFuture(this.f_nValue.getAndAdd(nDelta));
    }

    @Override
    public CompletableFuture<Integer> incrementAndGet() {
        return this.addAndGet(1);
    }

    @Override
    public CompletableFuture<Integer> decrementAndGet() {
        return this.addAndGet(-1);
    }

    @Override
    public CompletableFuture<Integer> addAndGet(int nDelta) {
        return CompletableFuture.completedFuture(this.f_nValue.addAndGet(nDelta));
    }

    @Override
    public CompletableFuture<Integer> getAndUpdate(Remote.IntUnaryOperator updateFunction) {
        return this.getAndUpdate((IntUnaryOperator)updateFunction);
    }

    @Override
    public CompletableFuture<Integer> getAndUpdate(IntUnaryOperator updateFunction) {
        return CompletableFuture.completedFuture(this.f_nValue.getAndUpdate(updateFunction));
    }

    @Override
    public CompletableFuture<Integer> updateAndGet(Remote.IntUnaryOperator updateFunction) {
        return this.updateAndGet((IntUnaryOperator)updateFunction);
    }

    @Override
    public CompletableFuture<Integer> updateAndGet(IntUnaryOperator updateFunction) {
        return CompletableFuture.completedFuture(this.f_nValue.updateAndGet(updateFunction));
    }

    @Override
    public CompletableFuture<Integer> getAndAccumulate(int x, Remote.IntBinaryOperator accumulatorFunction) {
        return this.getAndAccumulate(x, (IntBinaryOperator)accumulatorFunction);
    }

    @Override
    public CompletableFuture<Integer> getAndAccumulate(int nUpdate, IntBinaryOperator accumulatorFunction) {
        return CompletableFuture.completedFuture(this.f_nValue.getAndAccumulate(nUpdate, accumulatorFunction));
    }

    @Override
    public CompletableFuture<Integer> accumulateAndGet(int nUpdate, Remote.IntBinaryOperator accumulatorFunction) {
        return this.accumulateAndGet(nUpdate, (IntBinaryOperator)accumulatorFunction);
    }

    @Override
    public CompletableFuture<Integer> accumulateAndGet(int nUpdate, IntBinaryOperator accumulatorFunction) {
        return CompletableFuture.completedFuture(this.f_nValue.accumulateAndGet(nUpdate, accumulatorFunction));
    }

    @Override
    public CompletableFuture<Integer> compareAndExchange(int nExpectedValue, int nNewValue) {
        return CompletableFuture.completedFuture(this.f_nValue.compareAndExchange(nExpectedValue, nNewValue));
    }

    @Override
    public CompletableFuture<Integer> intValue() {
        return CompletableFuture.completedFuture(this.f_nValue.intValue());
    }

    @Override
    public CompletableFuture<Long> longValue() {
        return CompletableFuture.completedFuture(this.f_nValue.longValue());
    }

    @Override
    public CompletableFuture<Float> floatValue() {
        return CompletableFuture.completedFuture(Float.valueOf(this.f_nValue.floatValue()));
    }

    @Override
    public CompletableFuture<Double> doubleValue() {
        return CompletableFuture.completedFuture(this.f_nValue.doubleValue());
    }

    @Override
    public CompletableFuture<Byte> byteValue() {
        return CompletableFuture.completedFuture(this.f_nValue.byteValue());
    }

    @Override
    public CompletableFuture<Short> shortValue() {
        return CompletableFuture.completedFuture(this.f_nValue.shortValue());
    }

    public String toString() {
        return Integer.toString(this.get().join());
    }
}

