/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.ComposableContinuation;
import com.oracle.coherence.concurrent.executor.atomic.AtomicEnum;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ContinuationService<T> {
    protected final ConcurrentHashMap<T, ComposableContinuation> f_mapPendingContinuations = new ConcurrentHashMap();
    protected final ExecutorService[] f_aContinuationServices = new ExecutorService[7];
    protected final AtomicEnum<State> f_state;

    public ContinuationService(ThreadFactory threadFactory) {
        for (int i = 0; i < this.f_aContinuationServices.length; ++i) {
            this.f_aContinuationServices[i] = Executors.newSingleThreadExecutor(threadFactory);
        }
        this.f_state = AtomicEnum.of(State.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submit(ComposableContinuation continuation, T object) {
        if (this.f_state.get() == State.RUNNING) {
            Map.Entry entry;
            Object entryKey;
            Object object2;
            if (continuation == null) {
                return false;
            }
            Object key = object;
            if (this.f_mapPendingContinuations.containsKey(key) && (object2 = this.f_mapPendingContinuations.entrySet().iterator()).hasNext() && (entryKey = (entry = (Map.Entry)object2.next()).getKey()).equals(key)) {
                key = entryKey;
            }
            object2 = key;
            synchronized (object2) {
                ComposableContinuation composed;
                ComposableContinuation existing = this.f_mapPendingContinuations.get(key);
                ComposableContinuation composableContinuation = composed = existing == null ? continuation : existing.compose(continuation);
                if (composed != null) {
                    this.f_mapPendingContinuations.put(key, composed);
                    if (existing == null) {
                        int index = Math.abs(key.hashCode()) % this.f_aContinuationServices.length;
                        if (index < 0) {
                            index = 0;
                        }
                        this.f_aContinuationServices[index].submit(new ContinuationRunnable(key, index));
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandon(T object) {
        T t = object;
        synchronized (t) {
            this.f_mapPendingContinuations.remove(object);
        }
    }

    public void shutdown() {
        if (this.f_state.compareAndSet(State.RUNNING, State.SHUTDOWN)) {
            for (ExecutorService executorService : this.f_aContinuationServices) {
                try {
                    executorService.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdownNow() {
        if (this.f_state.compareAndSet(State.RUNNING, State.SHUTDOWN)) {
            for (ExecutorService executorService : this.f_aContinuationServices) {
                try {
                    executorService.shutdownNow();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public class ContinuationRunnable
    implements Runnable {
        protected final T m_object;
        protected final int m_nServiceIndex;

        public ContinuationRunnable(T object, int serviceIndex) {
            this.m_object = object;
            this.m_nServiceIndex = serviceIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ComposableContinuation continuation;
            Object t = this.m_object;
            synchronized (t) {
                continuation = ContinuationService.this.f_mapPendingContinuations.remove(this.m_object);
            }
            if (continuation == null) {
                Logger.fine(() -> String.format("ComposableContinuation for [%s] has been removed (ignoring request)", this.m_object));
            } else {
                try {
                    ExecutorTrace.log(() -> String.format("Executing continuation [%s] for [%s]", continuation, this.m_object));
                    continuation.proceed(null);
                }
                catch (Throwable t2) {
                    Logger.warn(() -> String.format("Failed to execute continuation [%s] for [%s]", continuation, this.m_object));
                    Logger.warn((String)"ComposableContinuation encountered", (Throwable)t2);
                }
            }
        }
    }

    private static enum State {
        RUNNING,
        SHUTDOWN;

    }
}

