/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.user_profile;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.user_profile.UserProfileCache;
import com.optimizely.ab.bucketing.UserProfileService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserProfileService
implements UserProfileService {
    @NonNull
    private final UserProfileCache userProfileCache;
    @NonNull
    private final Logger logger;

    DefaultUserProfileService(@NonNull UserProfileCache userProfileCache, @NonNull Logger logger) {
        this.userProfileCache = userProfileCache;
        this.logger = logger;
    }

    public static UserProfileService newInstance(@NonNull String projectId, @NonNull Context context) {
        UserProfileCache userProfileCache = new UserProfileCache(new UserProfileCache.DiskCache(new Cache(context, LoggerFactory.getLogger(Cache.class)), Executors.newSingleThreadExecutor(), LoggerFactory.getLogger(UserProfileCache.DiskCache.class), projectId), LoggerFactory.getLogger(UserProfileCache.class), new ConcurrentHashMap<String, Map<String, Object>>(), new UserProfileCache.LegacyDiskCache(new Cache(context, LoggerFactory.getLogger(Cache.class)), Executors.newSingleThreadExecutor(), LoggerFactory.getLogger(UserProfileCache.LegacyDiskCache.class), projectId));
        return new DefaultUserProfileService(userProfileCache, LoggerFactory.getLogger(DefaultUserProfileService.class));
    }

    @TargetApi(value=11)
    public void startInBackground(final StartCallback callback) {
        final DefaultUserProfileService userProfileService = this;
        AsyncTask<Void, Void, UserProfileService> initUserProfileTask = new AsyncTask<Void, Void, UserProfileService>(){

            protected UserProfileService doInBackground(Void[] params) {
                userProfileService.start();
                return userProfileService;
            }

            protected void onPostExecute(UserProfileService userProfileService2) {
                if (callback != null) {
                    callback.onStartComplete(userProfileService2);
                }
            }
        };
        try {
            initUserProfileTask.executeOnExecutor((Executor)Executors.newSingleThreadExecutor(), (Object[])new Void[0]);
        }
        catch (Exception e) {
            this.logger.error("Error loading user profile service from AndroidUserProfileServiceDefault");
            callback.onStartComplete(null);
        }
    }

    public void start() {
        this.userProfileCache.start();
    }

    @Nullable
    public Map<String, Object> lookup(String userId) {
        if (userId == null) {
            this.logger.error("Received null user ID, unable to lookup activation.");
            return null;
        }
        if (userId.isEmpty()) {
            this.logger.error("Received empty user ID, unable to lookup activation.");
            return null;
        }
        return this.userProfileCache.lookup(userId);
    }

    public void remove(String userId) {
        this.userProfileCache.remove(userId);
    }

    public void remove(String userId, String experimentId) {
        this.userProfileCache.remove(userId, experimentId);
    }

    public void save(Map<String, Object> userProfileMap) {
        this.userProfileCache.save(userProfileMap);
    }

    public static interface StartCallback {
        public void onStartComplete(UserProfileService var1);
    }
}

