/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import org.json.JSONException;
import org.json.JSONObject;

public class DatafileConfig {
    public static String defaultHost = "https://cdn.optimizely.com";
    public static String projectUrlSuffix = "/json/%s.json";
    public static String environmentUrlSuffix = "/datafiles/%s.json";
    public static String delimiter = "::::";
    private final String projectId;
    private final String sdkKey;
    private final String host;
    private final String datafileUrlString;

    public DatafileConfig(String projectId, String sdkKey, String host) {
        assert (projectId != null || sdkKey != null);
        this.projectId = projectId;
        this.sdkKey = sdkKey;
        this.host = host;
        this.datafileUrlString = sdkKey != null ? String.format(this.host + environmentUrlSuffix, sdkKey) : String.format(this.host + projectUrlSuffix, projectId);
    }

    public DatafileConfig(String projectId, String sdkKey) {
        this(projectId, sdkKey, defaultHost);
    }

    public String getKey() {
        return this.sdkKey != null ? this.sdkKey : this.projectId;
    }

    public String getUrl() {
        return this.datafileUrlString;
    }

    public String toJSONString() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("projectId", (Object)this.projectId);
            jsonObject.put("sdkKey", (Object)this.sdkKey);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DatafileConfig fromJSONString(String jsonString) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            String projectId = null;
            if (jsonObject.has("projectId")) {
                projectId = jsonObject.getString("projectId");
            }
            String environmentKey = null;
            if (jsonObject.has("sdkKey")) {
                environmentKey = jsonObject.getString("sdkKey");
            }
            return new DatafileConfig(projectId, environmentKey);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.projectId != null ? this.projectId : "null" + delimiter + (this.sdkKey != null ? this.sdkKey : "null");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatafileConfig)) {
            return false;
        }
        DatafileConfig p = (DatafileConfig)o;
        return this.projectId != null ? (p.projectId != null ? this.projectId.equals(p.projectId) : this.projectId == p.projectId) : (p.projectId == null && this.sdkKey != null ? (p.sdkKey != null ? this.sdkKey.equals(p.sdkKey) : this.sdkKey == p.sdkKey) : p.sdkKey == null);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.projectId == null ? 0 : this.projectId.hashCode()) + (this.sdkKey == null ? 0 : this.sdkKey.hashCode());
        return result;
    }
}

