/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.optimizely.ab.android.shared.OptlyStorage;
import java.io.BufferedInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class Client {
    static final int MAX_BACKOFF_TIMEOUT = (int)Math.pow(2.0, 5.0);
    @NonNull
    private final OptlyStorage optlyStorage;
    @NonNull
    private final Logger logger;

    public Client(@NonNull OptlyStorage optlyStorage, @NonNull Logger logger) {
        this.optlyStorage = optlyStorage;
        this.logger = logger;
    }

    @Nullable
    public HttpURLConnection openConnection(URL url) {
        try {
            return (HttpURLConnection)url.openConnection();
        }
        catch (Exception e) {
            this.logger.warn("Error making request to {}.", (Object)url);
            return null;
        }
    }

    public void setIfModifiedSince(@NonNull URLConnection urlConnection) {
        if (urlConnection == null || urlConnection.getURL() == null) {
            this.logger.error("Invalid connection");
            return;
        }
        long lastModified = this.optlyStorage.getLong(urlConnection.getURL().toString(), 0L);
        if (lastModified > 0L) {
            urlConnection.setIfModifiedSince(lastModified);
        }
    }

    public void saveLastModified(@NonNull URLConnection urlConnection) {
        if (urlConnection == null || urlConnection.getURL() == null) {
            this.logger.error("Invalid connection");
            return;
        }
        long lastModified = urlConnection.getLastModified();
        if (lastModified > 0L) {
            this.optlyStorage.saveLong(urlConnection.getURL().toString(), urlConnection.getLastModified());
        } else {
            this.logger.warn("CDN response didn't have a last modified header");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String readStream(@NonNull URLConnection urlConnection) {
        Scanner scanner = null;
        try {
            BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
            scanner = new Scanner(in).useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        catch (Exception e) {
            this.logger.warn("Error reading urlConnection stream.", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception e) {
                    this.logger.error("Problem with closing the scanner on a input stream", (Throwable)e);
                }
            }
        }
    }

    public <T> T execute(Request<T> request, int timeout, int power) {
        int baseTimeout = timeout;
        int maxTimeout = (int)Math.pow(baseTimeout, power);
        T response = null;
        while (timeout <= maxTimeout) {
            try {
                response = request.execute();
            }
            catch (Exception e) {
                this.logger.error("Request failed with error: ", (Throwable)e);
            }
            if (response != null && response != Boolean.FALSE) break;
            try {
                this.logger.info("Request failed, waiting {} seconds to try again", (Object)timeout);
                Thread.sleep(TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                this.logger.warn("Exponential backoff failed", (Throwable)e);
                break;
            }
            timeout *= baseTimeout;
        }
        return response;
    }

    public static interface Request<T> {
        public T execute();
    }
}

