/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import org.slf4j.Logger;

public class ServiceScheduler {
    @NonNull
    private final AlarmManager alarmManager;
    @NonNull
    private final PendingIntentFactory pendingIntentFactory;
    @NonNull
    private final Logger logger;

    public ServiceScheduler(@NonNull AlarmManager alarmManager, @NonNull PendingIntentFactory pendingIntentFactory, @NonNull Logger logger) {
        this.alarmManager = alarmManager;
        this.pendingIntentFactory = pendingIntentFactory;
        this.logger = logger;
    }

    public void schedule(Intent intent, long interval) {
        if (interval < 1L) {
            this.logger.error("Tried to schedule an interval less than 1");
            return;
        }
        if (this.isScheduled(intent)) {
            this.unschedule(intent);
        }
        PendingIntent pendingIntent = this.pendingIntentFactory.getPendingIntent(intent);
        this.alarmManager.setInexactRepeating(3, interval, interval, pendingIntent);
        this.logger.info("Scheduled {}", (Object)intent.getComponent().toShortString());
    }

    public void unschedule(Intent intent) {
        if (intent != null) {
            try {
                PendingIntent pendingIntent = this.pendingIntentFactory.getPendingIntent(intent);
                this.alarmManager.cancel(pendingIntent);
                pendingIntent.cancel();
                this.logger.info("Unscheduled {}", (Object)intent.getComponent().toShortString());
            }
            catch (Exception e) {
                this.logger.debug("Failed to unschedule service", (Throwable)e);
            }
        }
    }

    public boolean isScheduled(Intent intent) {
        return this.pendingIntentFactory.hasPendingIntent(intent);
    }

    public static class PendingIntentFactory {
        private Context context;

        public PendingIntentFactory(Context context) {
            this.context = context;
        }

        public boolean hasPendingIntent(Intent intent) {
            return this.getPendingIntent(intent, 0x20000000) != null;
        }

        public PendingIntent getPendingIntent(Intent intent) {
            return this.getPendingIntent(intent, 0x8000000);
        }

        private PendingIntent getPendingIntent(Intent intent, int flag) {
            return PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)flag);
        }
    }
}

