/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.shared;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.test.espresso.idling.CountingIdlingResource;
import android.util.Pair;
import java.util.LinkedList;
import java.util.List;

@VisibleForTesting
public class CountingIdlingResourceManager {
    @Nullable
    private static CountingIdlingResource countingIdlingResource;
    @NonNull
    private static List<Pair<String, String>> eventList;

    @VisibleForTesting
    @Nullable
    public static CountingIdlingResource getIdlingResource() {
        if (countingIdlingResource == null) {
            countingIdlingResource = new CountingIdlingResource("optimizely", true);
        }
        return countingIdlingResource;
    }

    @VisibleForTesting
    public static void setIdlingResource(@NonNull CountingIdlingResource countingIdlingResource) {
        CountingIdlingResourceManager.countingIdlingResource = countingIdlingResource;
    }

    @VisibleForTesting
    public static void increment() {
        if (countingIdlingResource != null) {
            countingIdlingResource.increment();
        }
    }

    @VisibleForTesting
    public static void decrement() {
        if (countingIdlingResource != null) {
            countingIdlingResource.decrement();
        }
    }

    @VisibleForTesting
    public static void recordEvent(Pair<String, String> event) {
        if (countingIdlingResource != null) {
            eventList.add(event);
        }
    }

    @VisibleForTesting
    public static void clearEvents() {
        eventList.clear();
    }

    @VisibleForTesting
    public static List<Pair<String, String>> getEvents() {
        return eventList;
    }

    static {
        eventList = new LinkedList<Pair<String, String>>();
    }
}

