/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import org.slf4j.Logger;

class EventSQLiteOpenHelper
extends SQLiteOpenHelper {
    static final int VERSION = 1;
    static final String DB_NAME = "optly-events-%s";
    static final String SQL_CREATE_EVENT_TABLE = "CREATE TABLE event (_id INTEGER PRIMARY KEY, url TEXT NOT NULL,requestBody TEXT NOT NULL)";
    private static final String SQL_DELETE_EVENT_TABLE = "DROP TABLE IF EXISTS event";
    @NonNull
    private final Logger logger;
    @NonNull
    private final String projectId;
    @NonNull
    private final Context context;

    @RequiresApi(api=11)
    EventSQLiteOpenHelper(@NonNull Context context, @NonNull String projectId, @Nullable SQLiteDatabase.CursorFactory factory, int version, @NonNull Logger logger) {
        super(context, String.format(DB_NAME, projectId), factory, version);
        this.logger = logger;
        this.projectId = projectId;
        this.context = context;
    }

    public void onCreate(SQLiteDatabase db) {
        try {
            this.context.deleteDatabase("optly-events");
            db.execSQL(SQL_CREATE_EVENT_TABLE);
            this.logger.info("Created event table with SQL: {}", (Object)SQL_CREATE_EVENT_TABLE);
        }
        catch (Exception e) {
            this.logger.error("Error creating optly-events table.", (Throwable)e);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public String getDbName() {
        return String.format(DB_NAME, this.projectId);
    }
}

