/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.optimizely.ab.android.datafile_handler.DatafileCache;
import com.optimizely.ab.android.datafile_handler.DatafileClient;
import com.optimizely.ab.android.datafile_handler.DatafileLoadedListener;
import com.optimizely.ab.android.datafile_handler.DatafileLoader;
import com.optimizely.ab.android.datafile_handler.DatafileService;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.shared.Client;
import com.optimizely.ab.android.shared.DatafileConfig;
import com.optimizely.ab.android.shared.OptlyStorage;
import java.util.concurrent.Executors;
import org.slf4j.LoggerFactory;

public class DatafileServiceConnection
implements ServiceConnection {
    @NonNull
    private final Context context;
    @NonNull
    private final DatafileConfig datafileConfig;
    @NonNull
    private final DatafileLoadedListener listener;
    private boolean bound = false;

    public DatafileServiceConnection(@NonNull DatafileConfig datafileConfig, @NonNull Context context, @NonNull DatafileLoadedListener listener) {
        this.datafileConfig = datafileConfig;
        this.context = context;
        this.listener = listener;
    }

    @RequiresApi(api=11)
    public void onServiceConnected(ComponentName className, IBinder service) {
        if (!(service instanceof DatafileService.LocalBinder)) {
            return;
        }
        DatafileService.LocalBinder binder = (DatafileService.LocalBinder)service;
        DatafileService datafileService = binder.getService();
        if (datafileService != null) {
            DatafileClient datafileClient = new DatafileClient(new Client(new OptlyStorage(this.context.getApplicationContext()), LoggerFactory.getLogger(OptlyStorage.class)), LoggerFactory.getLogger(DatafileClient.class));
            DatafileCache datafileCache = new DatafileCache(this.datafileConfig.getKey(), new Cache(this.context.getApplicationContext(), LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(DatafileCache.class));
            DatafileLoader datafileLoader = new DatafileLoader(datafileService, datafileClient, datafileCache, Executors.newSingleThreadExecutor(), LoggerFactory.getLogger(DatafileLoader.class));
            datafileService.getDatafile(this.datafileConfig.getUrl(), datafileLoader, this.listener);
        }
        this.bound = true;
    }

    public void onServiceDisconnected(ComponentName arg0) {
        this.bound = false;
        this.listener.onStop(this.context);
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(Boolean bound) {
        this.bound = bound;
    }
}

