/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.optimizely.ab.android.datafile_handler.DatafileCache;
import com.optimizely.ab.android.datafile_handler.DatafileClient;
import com.optimizely.ab.android.datafile_handler.DatafileLoadedListener;
import com.optimizely.ab.android.datafile_handler.DatafileLoader;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.shared.Client;
import com.optimizely.ab.android.shared.DatafileConfig;
import com.optimizely.ab.android.shared.OptlyStorage;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatafileService
extends Service {
    public static final String EXTRA_DATAFILE_CONFIG = "com.optimizely.ab.android.EXTRA_DATAFILE_CONFIG";
    public static final Integer JOB_ID = 2113;
    @NonNull
    private final IBinder binder = new LocalBinder();
    Logger logger = LoggerFactory.getLogger(DatafileService.class);
    private boolean isBound;

    @RequiresApi(api=11)
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            if (intent.hasExtra(EXTRA_DATAFILE_CONFIG)) {
                String extraDatafileConfig = intent.getStringExtra(EXTRA_DATAFILE_CONFIG);
                DatafileConfig datafileConfig = DatafileConfig.fromJSONString((String)extraDatafileConfig);
                DatafileClient datafileClient = new DatafileClient(new Client(new OptlyStorage(this.getApplicationContext()), LoggerFactory.getLogger(OptlyStorage.class)), LoggerFactory.getLogger(DatafileClient.class));
                DatafileCache datafileCache = new DatafileCache(datafileConfig.getKey(), new Cache(this.getApplicationContext(), LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(DatafileCache.class));
                String datafileUrl = datafileConfig.getUrl();
                DatafileLoader datafileLoader = new DatafileLoader(this, datafileClient, datafileCache, Executors.newSingleThreadExecutor(), LoggerFactory.getLogger(DatafileLoader.class));
                datafileLoader.getDatafile(datafileUrl, null);
            } else {
                this.logger.warn("Data file service received an intent with no project id extra");
            }
        } else {
            this.logger.warn("Data file service received a null intent");
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        this.isBound = true;
        return this.binder;
    }

    public boolean onUnbind(Intent intent) {
        this.isBound = false;
        this.logger.info("All clients are unbound from data file service");
        return false;
    }

    public boolean isBound() {
        return this.isBound;
    }

    public void stop() {
        this.stopSelf();
    }

    @RequiresApi(api=11)
    public void getDatafile(String datafileUrl, DatafileLoader datafileLoader, DatafileLoadedListener loadedListener) {
        datafileLoader.getDatafile(datafileUrl, loadedListener);
    }

    public class LocalBinder
    extends Binder {
        public DatafileService getService() {
            return DatafileService.this;
        }
    }
}

