/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.optimizely.ab.android.shared.Cache;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class DatafileCache {
    private static final String FILENAME = "optly-data-file-%s.json";
    @NonNull
    private final Cache cache;
    @NonNull
    private final String filename;
    @NonNull
    private final Logger logger;

    public DatafileCache(@NonNull String cacheKey, @NonNull Cache cache, @NonNull Logger logger) {
        this.cache = cache;
        this.filename = String.format(FILENAME, cacheKey);
        this.logger = logger;
    }

    public boolean delete() {
        return this.cache.delete(this.filename);
    }

    public boolean exists() {
        return this.cache.exists(this.filename);
    }

    @VisibleForTesting
    public String getFileName() {
        return this.filename;
    }

    @Nullable
    public JSONObject load() {
        String datafile = this.cache.load(this.filename);
        if (datafile == null) {
            return null;
        }
        try {
            return new JSONObject(datafile);
        }
        catch (JSONException e) {
            this.logger.error("Unable to parse data file", (Throwable)e);
            return null;
        }
    }

    public boolean save(String dataFile) {
        return this.cache.save(this.filename, dataFile);
    }
}

