/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.shared.DatafileConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

class BackgroundWatchersCache {
    static final String BACKGROUND_WATCHERS_FILE_NAME = "optly-background-watchers.json";
    @NonNull
    private final Cache cache;
    @NonNull
    private final Logger logger;
    static final String WATCHING = "watching";

    BackgroundWatchersCache(@NonNull Cache cache, @NonNull Logger logger) {
        this.cache = cache;
        this.logger = logger;
    }

    boolean setIsWatching(@NonNull DatafileConfig datafileConfig, boolean watching) {
        if (datafileConfig.getKey().isEmpty()) {
            this.logger.error("Passed in an empty string for projectId");
            return false;
        }
        try {
            JSONObject backgroundWatchers = this.load();
            if (backgroundWatchers != null) {
                backgroundWatchers.put(datafileConfig.getKey(), watching);
                return this.save(backgroundWatchers.toString());
            }
        }
        catch (JSONException e) {
            this.logger.error("Unable to update watching state for project id", (Throwable)e);
        }
        return false;
    }

    boolean isWatching(@NonNull DatafileConfig datafileConfig) {
        if (datafileConfig.getKey().isEmpty()) {
            this.logger.error("Passed in an empty string for projectId");
            return false;
        }
        try {
            JSONObject backgroundWatchers = this.load();
            if (backgroundWatchers != null) {
                if (backgroundWatchers.has(datafileConfig.getKey())) {
                    return backgroundWatchers.getBoolean(datafileConfig.getKey());
                }
                return false;
            }
        }
        catch (JSONException e) {
            this.logger.error("Unable check if project id is being watched", (Throwable)e);
        }
        return false;
    }

    List<DatafileConfig> getWatchingDatafileConfigs() {
        ArrayList<DatafileConfig> datafileConfigs = new ArrayList<DatafileConfig>();
        try {
            JSONObject backgroundWatchers = this.load();
            if (backgroundWatchers != null) {
                Iterator iterator = backgroundWatchers.keys();
                while (iterator.hasNext()) {
                    String projectKey = (String)iterator.next();
                    if (!backgroundWatchers.getBoolean(projectKey)) continue;
                    DatafileConfig datafileConfig = null;
                    boolean sdkKey = projectKey.matches(".*[A-Za-z].*");
                    datafileConfig = sdkKey ? new DatafileConfig(null, projectKey) : new DatafileConfig(projectKey, null);
                    datafileConfigs.add(datafileConfig);
                }
            }
        }
        catch (JSONException e) {
            this.logger.error("Unable to get watching project ids", (Throwable)e);
        }
        return datafileConfigs;
    }

    @Nullable
    private JSONObject load() throws JSONException {
        String backGroundWatchersFile = this.cache.load(BACKGROUND_WATCHERS_FILE_NAME);
        if (backGroundWatchersFile == null) {
            backGroundWatchersFile = "{}";
            this.logger.info("Creating background watchers file {}.", (Object)BACKGROUND_WATCHERS_FILE_NAME);
        }
        return new JSONObject(backGroundWatchersFile);
    }

    protected boolean delete() {
        return this.cache.delete(BACKGROUND_WATCHERS_FILE_NAME);
    }

    private boolean save(String backgroundWatchersJson) {
        this.logger.info("Saving background watchers file {}.", (Object)BACKGROUND_WATCHERS_FILE_NAME);
        boolean saved = this.cache.save(BACKGROUND_WATCHERS_FILE_NAME, backgroundWatchersJson);
        if (saved) {
            this.logger.info("Saved background watchers file {}.", (Object)BACKGROUND_WATCHERS_FILE_NAME);
        } else {
            this.logger.warn("Unable to save background watchers file {}.", (Object)BACKGROUND_WATCHERS_FILE_NAME);
        }
        return saved;
    }
}

