/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.optimizely.ab.android.datafile_handler.DatafileCache;
import com.optimizely.ab.android.datafile_handler.DatafileClient;
import com.optimizely.ab.android.datafile_handler.DatafileLoadedListener;
import com.optimizely.ab.android.datafile_handler.DatafileLoader;
import com.optimizely.ab.android.shared.Cache;
import com.optimizely.ab.android.shared.Client;
import com.optimizely.ab.android.shared.OptlyStorage;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatafileService
extends Service {
    public static final String EXTRA_PROJECT_ID = "com.optimizely.ab.android.EXTRA_PROJECT_ID";
    public static final String FORMAT_VERSIONED_CDN_URL = "https://cdn.optimizely.com/public/%s/datafile_v%s.json";
    static final String DATAFILE_VERSION = "3";
    @NonNull
    private final IBinder binder = new LocalBinder();
    Logger logger = LoggerFactory.getLogger(DatafileService.class);
    private boolean isBound;

    @RequiresApi(api=11)
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            if (intent.hasExtra(EXTRA_PROJECT_ID)) {
                String projectId = intent.getStringExtra(EXTRA_PROJECT_ID);
                DatafileClient datafileClient = new DatafileClient(new Client(new OptlyStorage(this.getApplicationContext()), LoggerFactory.getLogger(OptlyStorage.class)), LoggerFactory.getLogger(DatafileClient.class));
                DatafileCache datafileCache = new DatafileCache(projectId, new Cache(this.getApplicationContext(), LoggerFactory.getLogger(Cache.class)), LoggerFactory.getLogger(DatafileCache.class));
                String datafileUrl = DatafileService.getDatafileUrl(projectId);
                DatafileLoader datafileLoader = new DatafileLoader(this, datafileClient, datafileCache, Executors.newSingleThreadExecutor(), LoggerFactory.getLogger(DatafileLoader.class));
                datafileLoader.getDatafile(datafileUrl, null);
            } else {
                this.logger.warn("Data file service received an intent with no project id extra");
            }
        } else {
            this.logger.warn("Data file service received a null intent");
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        this.isBound = true;
        return this.binder;
    }

    public boolean onUnbind(Intent intent) {
        this.isBound = false;
        this.logger.info("All clients are unbound from data file service");
        return false;
    }

    public boolean isBound() {
        return this.isBound;
    }

    @NonNull
    public static String getDatafileUrl(@NonNull String projectId) {
        return String.format(FORMAT_VERSIONED_CDN_URL, projectId, DATAFILE_VERSION);
    }

    public void stop() {
        this.stopSelf();
    }

    @RequiresApi(api=11)
    public void getDatafile(String projectId, DatafileLoader datafileLoader, DatafileLoadedListener loadedListener) {
        String datafileUrl = DatafileService.getDatafileUrl(projectId);
        datafileLoader.getDatafile(datafileUrl, loadedListener);
    }

    public class LocalBinder
    extends Binder {
        public DatafileService getService() {
            return DatafileService.this;
        }
    }
}

