/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.datafile_handler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.optimizely.ab.android.shared.Cache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

class BackgroundWatchersCache {
    static final String BACKGROUND_WATCHERS_FILE_NAME = "optly-background-watchers.json";
    @NonNull
    private final Cache cache;
    @NonNull
    private final Logger logger;

    BackgroundWatchersCache(@NonNull Cache cache, @NonNull Logger logger) {
        this.cache = cache;
        this.logger = logger;
    }

    boolean setIsWatching(@NonNull String projectId, boolean watching) {
        if (projectId.isEmpty()) {
            this.logger.error("Passed in an empty string for projectId");
            return false;
        }
        try {
            JSONObject backgroundWatchers = this.load();
            if (backgroundWatchers != null) {
                backgroundWatchers.put(projectId, watching);
                return this.save(backgroundWatchers.toString());
            }
        }
        catch (JSONException e) {
            this.logger.error("Unable to update watching state for project id", (Throwable)e);
        }
        return false;
    }

    boolean isWatching(@NonNull String projectId) {
        if (projectId.isEmpty()) {
            this.logger.error("Passed in an empty string for projectId");
            return false;
        }
        try {
            JSONObject backgroundWatchers = this.load();
            if (backgroundWatchers != null) {
                return backgroundWatchers.getBoolean(projectId);
            }
        }
        catch (JSONException e) {
            this.logger.error("Unable check if project id is being watched", (Throwable)e);
        }
        return false;
    }

    List<String> getWatchingProjectIds() {
        ArrayList<String> projectIds = new ArrayList<String>();
        try {
            JSONObject backgroundWatchers = this.load();
            if (backgroundWatchers != null) {
                Iterator iterator = backgroundWatchers.keys();
                while (iterator.hasNext()) {
                    String projectId = (String)iterator.next();
                    if (!backgroundWatchers.getBoolean(projectId)) continue;
                    projectIds.add(projectId);
                }
            }
        }
        catch (JSONException e) {
            this.logger.error("Unable to get watching project ids", (Throwable)e);
        }
        return projectIds;
    }

    @Nullable
    private JSONObject load() throws JSONException {
        String backGroundWatchersFile = this.cache.load(BACKGROUND_WATCHERS_FILE_NAME);
        if (backGroundWatchersFile == null) {
            backGroundWatchersFile = "{}";
            this.logger.info("Creating background watchers file {}.", (Object)BACKGROUND_WATCHERS_FILE_NAME);
        }
        return new JSONObject(backGroundWatchersFile);
    }

    protected boolean delete() {
        return this.cache.delete(BACKGROUND_WATCHERS_FILE_NAME);
    }

    private boolean save(String backgroundWatchersJson) {
        this.logger.info("Saving background watchers file {}.", (Object)BACKGROUND_WATCHERS_FILE_NAME);
        boolean saved = this.cache.save(BACKGROUND_WATCHERS_FILE_NAME, backgroundWatchersJson);
        if (saved) {
            this.logger.info("Saved background watchers file {}.", (Object)BACKGROUND_WATCHERS_FILE_NAME);
        } else {
            this.logger.warn("Unable to save background watchers file {}.", (Object)BACKGROUND_WATCHERS_FILE_NAME);
        }
        return saved;
    }
}

