/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.views.xslt.AbstractAdapterElement;
import com.opensymphony.webwork.views.xslt.AdapterFactory;
import com.opensymphony.webwork.views.xslt.AdapterNode;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanAdapter
extends AbstractAdapterElement {
    private static final Object[] NULLPARAMS = new Object[0];
    private static Map propertyDescriptorCache;
    private Log log = LogFactory.getLog(this.getClass());

    public BeanAdapter() {
    }

    public BeanAdapter(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, Object value) {
        this.setContext(adapterFactory, parent, propertyName, value);
    }

    public String getTagName() {
        return this.getPropertyName();
    }

    public NodeList getChildNodes() {
        NodeList nl = super.getChildNodes();
        if (this.log.isDebugEnabled() && nl != null) {
            this.log.debug((Object)("BeanAdapter getChildNodes for: " + this.getTagName()));
            this.log.debug((Object)nl.toString());
        }
        return nl;
    }

    protected List buildChildAdapters() {
        this.log.debug((Object)("BeanAdapter building children.  PropName = " + this.getPropertyName()));
        ArrayList<Node> newAdapters = new ArrayList<Node>();
        Class<?> type = this.getPropertyValue().getClass();
        PropertyDescriptor[] props = this.getPropertyDescriptors(this.getPropertyValue());
        if (props.length > 0) {
            for (int i = 0; i < props.length; ++i) {
                Object propertyValue;
                Method m = props[i].getReadMethod();
                if (m == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Bean reading property method: " + m.getName()));
                }
                String propertyName = props[i].getName();
                try {
                    propertyValue = m.invoke(this.getPropertyValue(), NULLPARAMS);
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        e = (Exception)((InvocationTargetException)e).getTargetException();
                    }
                    this.log.error((Object)e);
                    continue;
                }
                Node childAdapter = propertyValue == null ? this.getAdapterFactory().adaptNullValue(this, propertyName) : this.getAdapterFactory().adaptNode(this, propertyName, propertyValue);
                if (childAdapter != null) {
                    newAdapters.add(childAdapter);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)(this + " adding adapter: " + childAdapter));
            }
        } else {
            this.log.info((Object)("Class " + type.getName() + " has no readable properties, " + " trying to adapt " + this.getPropertyName() + " with StringAdapter..."));
        }
        return newAdapters;
    }

    private synchronized PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        try {
            PropertyDescriptor[] props;
            if (propertyDescriptorCache == null) {
                propertyDescriptorCache = new HashMap();
            }
            if ((props = (PropertyDescriptor[])propertyDescriptorCache.get(bean.getClass())) == null) {
                this.log.debug((Object)("Caching property descriptor for " + bean.getClass().getName()));
                props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
                propertyDescriptorCache.put(bean.getClass(), props);
            }
            return props;
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new WebWorkException("Error getting property descriptors for " + bean + " : " + e.getMessage());
        }
    }
}

