/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.spring.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SessionContextAutowiringInterceptor
extends AroundInterceptor {
    private Integer autowireStrategy = new Integer(1);

    public void setAutowireStrategy(Integer autowireStrategy) {
        this.autowireStrategy = autowireStrategy;
    }

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        Map session = invocation.getInvocationContext().getSession();
        ApplicationContext applicationContext = (ApplicationContext)session.get("com.opensymphony.webwork.spring.ApplicationContextSessionListener_APP_CONTEXT");
        AutowireCapableBeanFactory factory = this.findAutoWiringBeanFactory(applicationContext);
        factory.autowireBeanProperties(invocation.getAction(), this.autowireStrategy.intValue(), false);
    }

    protected AutowireCapableBeanFactory findAutoWiringBeanFactory(ApplicationContext context) {
        if (context instanceof AutowireCapableBeanFactory) {
            return (AutowireCapableBeanFactory)context;
        }
        if (context instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)context).getBeanFactory();
        }
        if (context.getParent() != null) {
            return this.findAutoWiringBeanFactory(context.getParent());
        }
        return null;
    }
}

