/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet.util;

import com.opensymphony.webwork.portlet.context.PortletActionContext;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortletUrlHelper {
    private static final Log LOG = LogFactory.getLog((Class)PortletUrlHelper.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String AMP = "&";

    public static String buildUrl(String action, String namespace, Map params, String type, String mode, String state) {
        return PortletUrlHelper.buildUrl(action, namespace, params, null, type, mode, state, true, true);
    }

    public static String buildUrl(String action, String namespace, Map params, String scheme, String type, String portletMode, String windowState, boolean includeContext, boolean encodeResult) {
        RenderRequest request = PortletActionContext.getRenderRequest();
        RenderResponse response = PortletActionContext.getRenderResponse();
        LOG.debug((Object)("Creating url. Action = " + action + ", Namespace = " + namespace + ", Type = " + type));
        namespace = PortletUrlHelper.prependNamespace(namespace, portletMode);
        if (StringUtils.isEmpty((String)portletMode)) {
            portletMode = PortletActionContext.getRenderRequest().getPortletMode().toString();
        }
        String result = null;
        int paramStartIndex = action.indexOf(63);
        if (paramStartIndex > 0) {
            String value = action;
            action = value.substring(0, value.indexOf(63));
            String queryStr = value.substring(paramStartIndex + 1);
            StringTokenizer tok = new StringTokenizer(queryStr, AMP);
            while (tok.hasMoreTokens()) {
                String paramVal = tok.nextToken();
                String key = paramVal.substring(0, paramVal.indexOf(61));
                String val = paramVal.substring(paramVal.indexOf(61) + 1);
                params.put(key, new String[]{val});
            }
        }
        if (StringUtils.isNotEmpty((String)namespace)) {
            StringBuffer sb = new StringBuffer();
            sb.append(namespace);
            if (!action.startsWith("/") && !namespace.endsWith("/")) {
                sb.append("/");
            }
            action = sb.append(action).toString();
            LOG.debug((Object)("Resulting actionPath: " + action));
        }
        params.put("webwork.portlet.action", new String[]{action});
        PortletURL url = null;
        if ("action".equalsIgnoreCase(type)) {
            LOG.debug((Object)"Creating action url");
            url = response.createActionURL();
        } else {
            LOG.debug((Object)"Creating render url");
            url = response.createRenderURL();
        }
        params.put("webwork.portlet.mode", portletMode);
        url.setParameters(PortletUrlHelper.ensureParamsAreStringArrays(params));
        if ("HTTPS".equalsIgnoreCase(scheme)) {
            try {
                url.setSecure(true);
            }
            catch (PortletSecurityException e) {
                LOG.error((Object)"Cannot set scheme to https", (Throwable)e);
            }
        }
        try {
            url.setPortletMode(PortletUrlHelper.getPortletMode(request, portletMode));
            url.setWindowState(PortletUrlHelper.getWindowState(request, windowState));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to set mode or state:" + e.getMessage()), (Throwable)e);
        }
        result = url.toString();
        if (result.indexOf("&amp;") >= 0) {
            result = StringUtils.replace((String)result, (String)"&amp;", (String)AMP);
        }
        return result;
    }

    private static String prependNamespace(String namespace, String portletMode) {
        StringBuffer sb = new StringBuffer();
        PortletMode mode = PortletActionContext.getRenderRequest().getPortletMode();
        if (StringUtils.isNotEmpty((String)portletMode)) {
            mode = new PortletMode(portletMode);
        }
        String portletNamespace = PortletActionContext.getPortletNamespace();
        String modeNamespace = (String)PortletActionContext.getModeNamespaceMap().get(mode);
        LOG.debug((Object)("PortletNamespace: " + portletNamespace + ", modeNamespace: " + modeNamespace));
        if (StringUtils.isNotEmpty((String)portletNamespace)) {
            sb.append(portletNamespace);
        }
        if (StringUtils.isNotEmpty((String)modeNamespace)) {
            if (!modeNamespace.startsWith("/")) {
                sb.append("/");
            }
            sb.append(modeNamespace);
        }
        if (StringUtils.isNotEmpty((String)namespace)) {
            if (!namespace.startsWith("/")) {
                sb.append("/");
            }
            sb.append(namespace);
        }
        LOG.debug((Object)("Resulting namespace: " + sb));
        return sb.toString();
    }

    public static String buildResourceUrl(String value, Map params) {
        StringBuffer sb = new StringBuffer();
        if (!value.startsWith("/")) {
            sb.append("/");
        }
        sb.append(value);
        if (params != null && params.size() > 0) {
            sb.append("?");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = (String)params.get(key);
                sb.append(URLEncoder.encode(key)).append("=");
                sb.append(URLEncoder.encode(val));
                if (!it.hasNext()) continue;
                sb.append(AMP);
            }
        }
        RenderResponse resp = PortletActionContext.getRenderResponse();
        RenderRequest req = PortletActionContext.getRenderRequest();
        return resp.encodeURL(req.getContextPath() + sb.toString());
    }

    public static Map ensureParamsAreStringArrays(Map params) {
        HashMap result = null;
        if (params != null) {
            result = new HashMap(params.size());
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object val = params.get(key);
                if (val instanceof String[]) {
                    result.put(key, val);
                    continue;
                }
                result.put(key, new String[]{val.toString()});
            }
        }
        return result;
    }

    private static WindowState getWindowState(RenderRequest portletReq, String windowState) {
        WindowState state = portletReq.getWindowState();
        if (StringUtils.isNotEmpty((String)windowState)) {
            state = portletReq.getWindowState();
            if ("maximized".equalsIgnoreCase(windowState)) {
                state = WindowState.MAXIMIZED;
            } else if ("normal".equalsIgnoreCase(windowState)) {
                state = WindowState.NORMAL;
            } else if ("minimized".equalsIgnoreCase(windowState)) {
                state = WindowState.MINIMIZED;
            }
        }
        if (state == null) {
            state = WindowState.NORMAL;
        }
        return state;
    }

    private static PortletMode getPortletMode(RenderRequest portletReq, String portletMode) {
        PortletMode mode = portletReq.getPortletMode();
        if (StringUtils.isNotEmpty((String)portletMode)) {
            mode = portletReq.getPortletMode();
            if ("edit".equalsIgnoreCase(portletMode)) {
                mode = PortletMode.EDIT;
            } else if ("view".equalsIgnoreCase(portletMode)) {
                mode = PortletMode.VIEW;
            } else if ("help".equalsIgnoreCase(portletMode)) {
                mode = PortletMode.HELP;
            }
        }
        if (mode == null) {
            mode = PortletMode.VIEW;
        }
        return mode;
    }
}

