/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.interceptor.CookiesAware;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieInterceptor
extends AroundInterceptor {
    private static final long serialVersionUID = 4153142432948747305L;
    private static final Log LOG = LogFactory.getLog((Class)CookieInterceptor.class);
    private Set cookiesNameSet = Collections.EMPTY_SET;
    private Set cookiesValueSet = Collections.EMPTY_SET;

    public void setCookiesName(String cookiesName) {
        if (cookiesName != null) {
            this.cookiesNameSet = TextParseUtil.commaDelimitedStringToSet((String)cookiesName);
        }
    }

    public void setCookiesValue(String cookiesValue) {
        if (cookiesValue != null) {
            this.cookiesValueSet = TextParseUtil.commaDelimitedStringToSet((String)cookiesValue);
        }
    }

    public void destroy() {
    }

    public void init() {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"start interception");
        }
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        HttpServletRequest request = ServletActionContext.getRequest();
        LinkedHashMap cookiesMap = new LinkedHashMap();
        Cookie[] cookies = request.getCookies();
        for (int a = 0; a < cookies.length; ++a) {
            String name = cookies[a].getName();
            String value = cookies[a].getValue();
            if (this.cookiesNameSet.contains("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("contains cookie name [*] in configured cookies name set, cookie with name [" + name + "] with value [" + value + "] will be injected"));
                }
                this.populateCookieValueIntoStack(name, value, cookiesMap, stack);
                continue;
            }
            if (!this.cookiesNameSet.contains(cookies[a].getName())) continue;
            this.populateCookieValueIntoStack(name, value, cookiesMap, stack);
        }
        this.injectIntoCookiesAwareAction(invocation.getAction(), cookiesMap);
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"after interception");
        }
    }

    protected void populateCookieValueIntoStack(String cookieName, String cookieValue, Map cookiesMap, OgnlValueStack stack) {
        if (this.cookiesValueSet.isEmpty() || this.cookiesValueSet.contains("*")) {
            if (LOG.isDebugEnabled()) {
                if (this.cookiesValueSet.isEmpty()) {
                    LOG.debug((Object)("no cookie value is configured, cookie with name [" + cookieName + "] with value [" + cookieValue + "] will be injected"));
                } else if (this.cookiesValueSet.contains("*")) {
                    LOG.debug((Object)("interceptor is configured to accept any value, cookie with name [" + cookieName + "] with value [" + cookieValue + "] will be injected"));
                }
            }
            cookiesMap.put(cookieName, cookieValue);
            stack.setValue(cookieName, (Object)cookieValue);
        } else if (this.cookiesValueSet.contains(cookieValue)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("both configured cookie name and value matched, cookie [" + cookieName + "] with value [" + cookieValue + "] will be injected"));
            }
            cookiesMap.put(cookieName, cookieValue);
            stack.setValue(cookieName, (Object)cookieValue);
        }
    }

    protected void injectIntoCookiesAwareAction(Object action, Map cookiesMap) {
        if (action instanceof CookiesAware) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("action [" + action + "] implements CookiesAware, injecting cookies map [" + cookiesMap + "]"));
            }
            ((CookiesAware)action).setCookiesMap(cookiesMap);
        }
    }
}

