/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.webwork.WebWorkStatics;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WebWorkResultSupport
implements Result,
WebWorkStatics {
    private static final Log _log = LogFactory.getLog((Class)WebWorkResultSupport.class);
    public static final String DEFAULT_PARAM = "location";
    protected boolean parse = true;
    protected boolean encode = false;
    protected String location;

    public void setLocation(String location) {
        this.location = location;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        this.doExecute(this.conditionalParse(this.location, invocation), invocation);
    }

    protected String conditionalParse(String param, ActionInvocation invocation) {
        if (this.parse && param != null && invocation != null) {
            return TextParseUtil.translateVariables((String)param, (OgnlValueStack)invocation.getStack(), (TextParseUtil.ParsedValueEvaluator)new TextParseUtil.ParsedValueEvaluator(){

                public Object evaluate(Object parsedValue) {
                    if (WebWorkResultSupport.this.encode && parsedValue != null) {
                        try {
                            return URLEncoder.encode(parsedValue.toString(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            _log.warn((Object)("error while trying to encode [" + parsedValue + "]"), (Throwable)e);
                        }
                    }
                    return parsedValue;
                }
            });
        }
        return param;
    }

    protected abstract void doExecute(String var1, ActionInvocation var2) throws Exception;
}

