/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.config;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.config.DelegatingConfiguration;
import com.opensymphony.webwork.config.PropertiesConfiguration;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfiguration
extends Configuration {
    protected Log log = LogFactory.getLog(this.getClass());
    Configuration config;

    public DefaultConfiguration() {
        String name;
        ArrayList<PropertiesConfiguration> list = new ArrayList<PropertiesConfiguration>();
        try {
            list.add(new PropertiesConfiguration("webwork"));
        }
        catch (Exception e) {
            this.log.warn((Object)"Could not find webwork.properties");
        }
        try {
            list.add(new PropertiesConfiguration("com/opensymphony/webwork/default"));
        }
        catch (Exception e) {
            this.log.error((Object)"Could not find com/opensymphony/webwork/default.properties", (Throwable)e);
        }
        Configuration[] configList = new Configuration[list.size()];
        this.config = new DelegatingConfiguration(list.toArray(configList));
        try {
            StringTokenizer configFiles = new StringTokenizer((String)this.config.getImpl("webwork.custom.properties"), ",");
            while (configFiles.hasMoreTokens()) {
                name = configFiles.nextToken();
                try {
                    list.add(new PropertiesConfiguration(name));
                }
                catch (Exception e) {
                    this.log.error((Object)("Could not find " + name + ".properties. Skipping"));
                }
            }
            configList = new Configuration[list.size()];
            this.config = new DelegatingConfiguration(list.toArray(configList));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            LocalizedTextUtil.addDefaultResourceBundle((String)"com/opensymphony/webwork/webwork-messages");
            StringTokenizer bundleFiles = new StringTokenizer((String)this.config.getImpl("webwork.custom.i18n.resources"), ", ");
            while (bundleFiles.hasMoreTokens()) {
                name = bundleFiles.nextToken();
                try {
                    this.log.info((Object)("Loading global messages from " + name));
                    LocalizedTextUtil.addDefaultResourceBundle((String)name);
                }
                catch (Exception e) {
                    this.log.error((Object)("Could not find " + name + ".properties. Skipping"));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        this.config.setImpl(aName, aValue);
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        return this.config.getImpl(aName);
    }

    public boolean isSetImpl(String aName) {
        return this.config.isSetImpl(aName);
    }

    public Iterator listImpl() {
        return this.config.listImpl();
    }
}

