/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.Div;
import com.opensymphony.webwork.components.TabbedPanel;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Panel
extends Div {
    private static final Log LOG = LogFactory.getLog((Class)Panel.class);
    public static final String TEMPLATE = "tab";
    public static final String TEMPLATE_CLOSE = "tab-close";
    public static final String COMPONENT_NAME = Panel.class.getName();
    protected String tabName;
    protected String subscribeTopicName;
    protected String remote;

    public Panel(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public boolean end(Writer writer, String body) {
        TabbedPanel tabbedPanel = (TabbedPanel)this.findAncestor(TabbedPanel.class);
        this.subscribeTopicName = tabbedPanel.getTopicName();
        tabbedPanel.addTab(this);
        return super.end(writer, body);
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.tabName != null) {
            this.addParameter("tabName", this.findString(this.tabName));
        }
        if (this.subscribeTopicName != null) {
            this.addParameter("subscribeTopicName", this.subscribeTopicName);
        }
        if (this.remote != null && "true".equalsIgnoreCase(this.remote)) {
            this.addParameter("remote", "true");
        } else {
            this.addParameter("remote", "false");
        }
    }

    public String getTabName() {
        return this.findString(this.tabName);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public void setSubscribeTopicName(String subscribeTopicName) {
        this.subscribeTopicName = subscribeTopicName;
    }

    public void setRemote(String remote) {
        this.remote = remote;
    }
}

