/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.extra;

import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheGroupEvent;
import com.opensymphony.oscache.base.events.CacheMapAccessEvent;
import com.opensymphony.oscache.base.events.CacheMapAccessEventListener;
import com.opensymphony.oscache.base.events.CacheMapAccessEventType;
import com.opensymphony.oscache.base.events.CachePatternEvent;
import com.opensymphony.oscache.base.events.CachewideEvent;
import com.opensymphony.oscache.base.events.ScopeEvent;
import com.opensymphony.oscache.base.events.ScopeEventListener;
import com.opensymphony.oscache.extra.ScopeEventListenerImpl;

public class StatisticListenerImpl
implements CacheMapAccessEventListener,
CacheEntryEventListener,
ScopeEventListener {
    private static int hitCount = 0;
    private static int missCount = 0;
    private static int staleHitCount = 0;
    private static int hitCountSum = 0;
    private static int missCountSum = 0;
    private static int staleHitCountSum = 0;
    private static int flushCount = 0;
    private static int entriesAdded = 0;
    private static int entriesRemoved = 0;
    private static int entriesUpdated = 0;

    public void accessed(CacheMapAccessEvent event) {
        CacheMapAccessEventType type = event.getEventType();
        if (type == CacheMapAccessEventType.HIT) {
            ++hitCount;
        } else if (type == CacheMapAccessEventType.STALE_HIT) {
            ++staleHitCount;
        } else if (type == CacheMapAccessEventType.MISS) {
            ++missCount;
        }
    }

    private void flushed(String info) {
        ++flushCount;
        hitCountSum += hitCount;
        staleHitCountSum += staleHitCount;
        missCountSum += missCount;
        hitCount = 0;
        staleHitCount = 0;
        missCount = 0;
    }

    public void scopeFlushed(ScopeEvent event) {
        this.flushed("scope " + ScopeEventListenerImpl.SCOPE_NAMES[event.getScope()]);
    }

    public void cacheEntryAdded(CacheEntryEvent event) {
        ++entriesAdded;
    }

    public void cacheEntryFlushed(CacheEntryEvent event) {
        if (!"NESTED".equals(event.getOrigin())) {
            this.flushed("entry " + event.getKey() + " / " + event.getOrigin());
        }
    }

    public void cacheEntryRemoved(CacheEntryEvent event) {
        ++entriesRemoved;
    }

    public void cacheEntryUpdated(CacheEntryEvent event) {
        ++entriesUpdated;
    }

    public void cacheGroupFlushed(CacheGroupEvent event) {
        this.flushed("group " + event.getGroup());
    }

    public void cachePatternFlushed(CachePatternEvent event) {
        this.flushed("pattern " + event.getPattern());
    }

    public void cacheFlushed(CachewideEvent event) {
        this.flushed("wide " + event.getDate());
    }

    public String toString() {
        return "StatisticListenerImpl: Hit = " + hitCount + " / " + hitCountSum + ", stale hit = " + staleHitCount + " / " + staleHitCountSum + ", miss = " + missCount + " / " + missCountSum + ", flush = " + flushCount + ", entries (added, removed, updates) = " + entriesAdded + ", " + entriesRemoved + ", " + entriesUpdated;
    }

    public int getEntriesAdded() {
        return entriesAdded;
    }

    public int getEntriesRemoved() {
        return entriesRemoved;
    }

    public int getEntriesUpdated() {
        return entriesUpdated;
    }

    public int getFlushCount() {
        return flushCount;
    }

    public int getHitCount() {
        return hitCount;
    }

    public int getHitCountSum() {
        return hitCountSum;
    }

    public int getMissCount() {
        return missCount;
    }

    public int getMissCountSum() {
        return missCountSum;
    }

    public int getStaleHitCount() {
        return staleHitCount;
    }

    public int getStaleHitCountSum() {
        return staleHitCountSum;
    }
}

