/*
 * Decompiled with CFR 0.152.
 */
package com.opensooq.pluto.base;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.opensooq.pluto.listeners.OnItemClickListener;

public abstract class PlutoViewHolder<T>
extends RecyclerView.ViewHolder {
    protected final Context mContext;
    private OnItemClickListener<T> mOnItemClickListener;
    int mPosition = -1;
    private int realAdapterCount;
    private final SparseArray<View> views = new SparseArray();

    void setOnItemClickListener(OnItemClickListener<T> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    void setRealAdapterCount(int realAdapterCount) {
        this.realAdapterCount = realAdapterCount;
    }

    public PlutoViewHolder(ViewGroup parent, @LayoutRes int itemLayoutId) {
        super(LayoutInflater.from((Context)parent.getContext()).inflate(itemLayoutId, parent, false));
        this.mContext = this.itemView.getContext();
        this.itemView.setOnClickListener(v -> {
            this.mPosition = this.getAdapterPosition();
            if (this.mOnItemClickListener == null || this.mPosition == -1) {
                return;
            }
            this.mPosition %= this.realAdapterCount;
            this.mOnItemClickListener.onItemClicked(this.getTag(), this.mPosition);
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setTag(T a) {
        this.itemView.setTag(a);
    }

    public abstract void set(T var1, int var2);

    public T getTag() {
        Object tag = this.itemView.getTag();
        if (tag != null) {
            return (T)tag;
        }
        return null;
    }

    public <T extends View> T getView(@IdRes int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (T)view;
    }
}

