/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.util;

import java.net.URL;
import java.util.regex.Pattern;

public class URLUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("(https?|ftp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final String SCHEMA_SEPARATOR = "://";
    public static final String SCHEME_HTTP = "http://";
    public static final String SCHEME_HTTPS = "https://";
    public static final char USERNAME_SEPARATOR = '@';

    private URLUtils() {
    }

    public static String ensureStartsWithHttps(String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        if (url.indexOf(SCHEMA_SEPARATOR) > 0) {
            return url;
        }
        return HTTPS + SCHEMA_SEPARATOR + url;
    }

    public static boolean isUrl(String string) {
        return URL_PATTERN.matcher(string).matches();
    }

    public static String appendPath(String parent, String child) {
        if (parent.charAt(parent.length() - 1) == '/') {
            if (child.charAt(0) == '/') {
                return parent + child.substring(1);
            }
            return parent + child;
        }
        if (child.charAt(0) == '/') {
            return parent + child;
        }
        return parent + '/' + child;
    }

    public static String toString(URL url) {
        if (url == null) {
            return null;
        }
        return url.toString();
    }
}

