/*
 * Decompiled with CFR 0.152.
 */
package com.omh.android.auth.nongms.presentation.redirect;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.omh.android.auth.api.models.OmhAuthException;
import com.omh.android.auth.nongms.databinding.ActivityRedirectBinding;
import com.omh.android.auth.nongms.domain.models.ApiResult;
import com.omh.android.auth.nongms.domain.models.OAuthTokens;
import com.omh.android.auth.nongms.presentation.redirect.RedirectActivity;
import com.omh.android.auth.nongms.presentation.redirect.RedirectViewModel;
import com.omh.android.auth.nongms.utils.EventWrapper;
import com.omh.android.auth.nongms.utils.EventWrapperKt;
import com.omh.android.auth.nongms.utils.lifecycle.LifecycleUtil;
import java.io.Serializable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0002J\u001e\u0010\u0019\u001a\u00020\u00162\u0014\u0010\u001a\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0018\u00010\u001bH\u0002J\u0012\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\u0012\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010#\u001a\u00020\u0016H\u0002J\u001c\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\b\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Lcom/omh/android/auth/nongms/presentation/redirect/RedirectActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "binding", "Lcom/omh/android/auth/nongms/databinding/ActivityRedirectBinding;", "getBinding", "()Lcom/omh/android/auth/nongms/databinding/ActivityRedirectBinding;", "binding$delegate", "Lkotlin/Lazy;", "caughtRedirect", "", "clientId", "", "tabsLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "viewModel", "Lcom/omh/android/auth/nongms/presentation/redirect/RedirectViewModel;", "getViewModel", "()Lcom/omh/android/auth/nongms/presentation/redirect/RedirectViewModel;", "viewModel$delegate", "handleCustomTabsClosed", "", "handleLoginError", "error", "observeTokenResponse", "eventWrapper", "Lcom/omh/android/auth/nongms/utils/EventWrapper;", "Lcom/omh/android/auth/nongms/domain/models/ApiResult;", "Lcom/omh/android/auth/nongms/domain/models/OAuthTokens;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "intent", "openCustomTabLogin", "returnResult", "result", "", "exception", "Lcom/omh/android/auth/api/models/OmhAuthException;", "Companion", "auth-api-non-gms_release"})
public final class RedirectActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy viewModel$delegate;
    @NotNull
    private final Lazy binding$delegate;
    private boolean caughtRedirect;
    @NotNull
    private String clientId;
    @NotNull
    private final ActivityResultLauncher<Intent> tabsLauncher;
    @NotNull
    public static final String SCOPES = "scopes";
    @NotNull
    public static final String CLIENT_ID = "client_id";
    @NotNull
    public static final String ACCESS_DENIED_RESPONSE = "access_denied";

    /*
     * WARNING - void declaration
     */
    public RedirectActivity() {
        void $this$viewModels_u24default$iv;
        ComponentActivity componentActivity = (ComponentActivity)this;
        Function0 factoryProducer$iv = viewModel.2.INSTANCE;
        Function0 extrasProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 function0 = factoryProducer$iv;
        if (function0 == null) {
            function0 = (Function0)new Function0<ViewModelProvider.Factory>((ComponentActivity)$this$viewModels_u24default$iv){
                final /* synthetic */ ComponentActivity $this_viewModels;
                {
                    this.$this_viewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    ViewModelProvider.Factory factory = this.$this_viewModels.getDefaultViewModelProviderFactory();
                    Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"defaultViewModelProviderFactory");
                    return factory;
                }
            };
        }
        Function0 factoryPromise$iv = function0;
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(RedirectViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_viewModels.getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"viewModelStore");
                return viewModelStore;
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, (ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    CreationExtras creationExtras = this.$this_viewModels.getDefaultViewModelCreationExtras();
                    function0 = creationExtras;
                    Intrinsics.checkNotNullExpressionValue((Object)creationExtras, (String)"this.defaultViewModelCreationExtras");
                }
                return function0;
            }
        });
        this.binding$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ActivityRedirectBinding>(this){
            final /* synthetic */ RedirectActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ActivityRedirectBinding invoke() {
                ActivityRedirectBinding activityRedirectBinding = ActivityRedirectBinding.inflate(LayoutInflater.from((Context)((Context)this.this$0)));
                Intrinsics.checkNotNullExpressionValue((Object)activityRedirectBinding, (String)"inflate(LayoutInflater.from(this))");
                return activityRedirectBinding;
            }
        }));
        this.clientId = "";
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> RedirectActivity.tabsLauncher$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026tomTabsClosed()\n        }");
        this.tabsLauncher = activityResultLauncher;
    }

    private final RedirectViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (RedirectViewModel)((Object)lazy.getValue());
    }

    private final ActivityRedirectBinding getBinding() {
        Lazy lazy = this.binding$delegate;
        return (ActivityRedirectBinding)lazy.getValue();
    }

    private final void handleCustomTabsClosed() {
        Lifecycle lifecycle = this.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"lifecycle");
        LifecycleUtil.INSTANCE.runOnResume(lifecycle, (LifecycleOwner)this, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RedirectActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!RedirectActivity.access$getCaughtRedirect$p(this.this$0)) {
                    RedirectActivity.access$returnResult(this.this$0, 0, (OmhAuthException)new OmhAuthException.LoginCanceledException(null, 1, null));
                }
            }
        }));
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView((View)this.getBinding().getRoot());
        if (this.getIntent().getStringExtra(CLIENT_ID) == null) {
            this.returnResult(0, (OmhAuthException)new OmhAuthException.RecoverableLoginException(2, null, 2, null));
            return;
        }
        String string = this.getIntent().getStringExtra(CLIENT_ID);
        Intrinsics.checkNotNull((Object)string);
        this.clientId = string;
        this.openCustomTabLogin();
        this.getViewModel().getTokenResponseEvent().observe((LifecycleOwner)this, arg_0 -> RedirectActivity.onCreate$lambda$1((Function1)new Function1<EventWrapper<ApiResult<? extends OAuthTokens>>, Unit>((Object)this){

            public final void invoke(@Nullable EventWrapper<ApiResult<OAuthTokens>> p0) {
                RedirectActivity.access$observeTokenResponse((RedirectActivity)((Object)this.receiver), p0);
            }
        }, arg_0));
    }

    private final void observeTokenResponse(EventWrapper<ApiResult<OAuthTokens>> eventWrapper) {
        if (EventWrapperKt.nullOrHandled(eventWrapper)) {
            return;
        }
        ApiResult<OAuthTokens> result = eventWrapper.getContentIfHandled();
        if (result instanceof ApiResult.Success) {
            RedirectActivity.returnResult$default(this, -1, null, 2, null);
        } else if (result instanceof ApiResult.Error.NetworkError) {
            this.returnResult(0, (OmhAuthException)new OmhAuthException.RecoverableLoginException(4, ((ApiResult.Error.NetworkError)result).getCause()));
        } else {
            this.returnResult(0, (OmhAuthException)new OmhAuthException.UnrecoverableLoginException(null, 1, null));
        }
    }

    private final void openCustomTabLogin() {
        String scopes = this.getIntent().getStringExtra(SCOPES);
        CharSequence charSequence = scopes;
        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)this.getPackageName()) == null || charSequence.length() == 0) {
            this.returnResult(0, (OmhAuthException)new OmhAuthException.RecoverableLoginException(2, null, 2, null));
            return;
        }
        RedirectViewModel redirectViewModel = this.getViewModel();
        String string = this.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName");
        Uri uri = redirectViewModel.getLoginUrl(scopes, string, this.clientId);
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
        CustomTabsIntent customTabsIntent = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"builder.build()");
        CustomTabsIntent customTabsIntent2 = customTabsIntent;
        customTabsIntent2.intent.setData(uri);
        this.tabsLauncher.launch((Object)customTabsIntent2.intent);
    }

    protected void onNewIntent(@Nullable Intent intent) {
        String error;
        Uri data;
        super.onNewIntent(intent);
        this.caughtRedirect = true;
        Intent intent2 = intent;
        Uri uri = data = intent2 != null ? intent2.getData() : null;
        String authCode = uri != null ? uri.getQueryParameter("code") : null;
        Uri uri2 = data;
        String string = error = uri2 != null ? uri2.getQueryParameter("error") : null;
        if (authCode == null) {
            this.handleLoginError(error);
            return;
        }
        RedirectViewModel redirectViewModel = this.getViewModel();
        String string2 = this.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageName");
        redirectViewModel.requestTokens(authCode, string2, this.clientId);
    }

    private final void handleLoginError(String error) {
        int code = Intrinsics.areEqual((Object)error, (Object)ACCESS_DENIED_RESPONSE) ? 6 : -1;
        this.returnResult(0, (OmhAuthException)new OmhAuthException.RecoverableLoginException(code, null, 2, null));
    }

    private final void returnResult(int result, OmhAuthException exception) {
        Intent intent = new Intent();
        if (result == 0) {
            intent.putExtra("cause", (Serializable)exception);
        }
        this.setResult(result, intent);
        this.finish();
    }

    static /* synthetic */ void returnResult$default(RedirectActivity redirectActivity, int n, OmhAuthException omhAuthException, int n2, Object object) {
        if ((n2 & 2) != 0) {
            omhAuthException = null;
        }
        redirectActivity.returnResult(n, omhAuthException);
    }

    private static final void tabsLauncher$lambda$0(RedirectActivity this$0, ActivityResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.handleCustomTabsClosed();
    }

    private static final void onCreate$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$getCaughtRedirect$p(RedirectActivity $this) {
        return $this.caughtRedirect;
    }

    public static final /* synthetic */ void access$returnResult(RedirectActivity $this, int result, OmhAuthException exception) {
        $this.returnResult(result, exception);
    }

    public static final /* synthetic */ void access$observeTokenResponse(RedirectActivity $this, EventWrapper eventWrapper) {
        $this.observeTokenResponse(eventWrapper);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/omh/android/auth/nongms/presentation/redirect/RedirectActivity$Companion;", "", "()V", "ACCESS_DENIED_RESPONSE", "", "CLIENT_ID", "SCOPES", "auth-api-non-gms_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

