/*
 * Decompiled with CFR 0.152.
 */
package com.omh.android.auth.nongms.presentation;

import android.content.Context;
import android.content.Intent;
import com.omh.android.auth.api.OmhAuthClient;
import com.omh.android.auth.api.async.OmhTask;
import com.omh.android.auth.api.models.OmhAuthException;
import com.omh.android.auth.api.models.OmhUserProfile;
import com.omh.android.auth.nongms.data.login.AuthRepositoryImpl;
import com.omh.android.auth.nongms.data.user.UserRepositoryImpl;
import com.omh.android.auth.nongms.domain.auth.AuthRepository;
import com.omh.android.auth.nongms.domain.auth.AuthUseCase;
import com.omh.android.auth.nongms.domain.models.ApiResult;
import com.omh.android.auth.nongms.domain.user.ProfileUseCase;
import com.omh.android.auth.nongms.domain.user.UserRepository;
import com.omh.android.auth.nongms.presentation.OmhAuthClientImpl;
import com.omh.android.auth.nongms.presentation.OmhAuthFactoryImpl;
import com.omh.android.auth.nongms.presentation.OmhNonGmsTask;
import com.omh.android.auth.nongms.presentation.redirect.RedirectActivity;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/omh/android/auth/nongms/presentation/OmhAuthClientImpl;", "Lcom/omh/android/auth/api/OmhAuthClient;", "clientId", "", "scopes", "context", "Landroid/content/Context;", "(Ljava/lang/String;Ljava/lang/String;Landroid/content/Context;)V", "applicationContext", "getAccountFromIntent", "Lcom/omh/android/auth/api/models/OmhUserProfile;", "data", "Landroid/content/Intent;", "getCredentials", "", "getLoginIntent", "getUser", "revokeToken", "Lcom/omh/android/auth/api/async/OmhTask;", "", "signOut", "Builder", "auth-api-non-gms_release"})
public final class OmhAuthClientImpl
implements OmhAuthClient {
    @NotNull
    private final String clientId;
    @NotNull
    private final String scopes;
    @NotNull
    private final Context applicationContext;

    public OmhAuthClientImpl(@NotNull String clientId, @NotNull String scopes, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.clientId = clientId;
        this.scopes = scopes;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.applicationContext = context2;
    }

    @NotNull
    public Intent getLoginIntent() {
        Intent intent = new Intent(this.applicationContext, RedirectActivity.class).putExtra("client_id", this.clientId).putExtra("scopes", this.scopes);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(applicationContex\u2026tActivity.SCOPES, scopes)");
        return intent;
    }

    @Nullable
    public OmhUserProfile getUser() {
        UserRepository userRepository = UserRepositoryImpl.Companion.getUserRepository$default(UserRepositoryImpl.Companion, this.applicationContext, null, 2, null);
        ProfileUseCase profileUseCase = ProfileUseCase.Companion.createUserProfileUseCase(userRepository);
        return profileUseCase.getProfileData();
    }

    @NotNull
    public Object getCredentials() {
        return OmhAuthFactoryImpl.INSTANCE.getCredentials$auth_api_non_gms_release(this.clientId, this.applicationContext);
    }

    @NotNull
    public OmhTask<Unit> signOut() {
        AuthRepository authRepository = AuthRepositoryImpl.Companion.getAuthRepository$default(AuthRepositoryImpl.Companion, this.applicationContext, null, 2, null);
        AuthUseCase authUseCase = AuthUseCase.Companion.createAuthUseCase(authRepository);
        return new OmhNonGmsTask((Function1)new Function1<Continuation<? super Unit>, Object>((Object)authUseCase){

            @Nullable
            public final Object invoke(@NotNull Continuation<? super Unit> $completion) {
                return OmhAuthClientImpl.access$signOut$logout((AuthUseCase)signOut.1.access$getReceiver$p(this), $completion);
            }

            public static final /* synthetic */ Object access$getReceiver$p(signOut.1 $this) {
                return $this.receiver;
            }
        });
    }

    @NotNull
    public OmhUserProfile getAccountFromIntent(@Nullable Intent data) {
        Intent intent = data;
        boolean bl = intent != null ? intent.hasExtra("cause") : false;
        if (bl) {
            Serializable serializable = data.getSerializableExtra("cause");
            Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type com.omh.android.auth.api.models.OmhAuthException");
            OmhAuthException exception = (OmhAuthException)serializable;
            throw exception;
        }
        OmhUserProfile omhUserProfile = this.getUser();
        if (omhUserProfile == null) {
            throw new OmhAuthException.UnrecoverableLoginException(new Throwable("No user profile stored"));
        }
        return omhUserProfile;
    }

    @NotNull
    public OmhTask<Unit> revokeToken() {
        AuthRepository authRepository = AuthRepositoryImpl.Companion.getAuthRepository$default(AuthRepositoryImpl.Companion, this.applicationContext, null, 2, null);
        AuthUseCase authUseCase = AuthUseCase.Companion.createAuthUseCase(authRepository);
        return new OmhNonGmsTask((Function1)new Function1<Continuation<? super Unit>, Object>(authUseCase, null){
            int label;
            final /* synthetic */ AuthUseCase $authUseCase;
            {
                this.$authUseCase = $authUseCase;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$authUseCase.revokeToken((Continuation<? super ApiResult<Unit>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        apiResult = (ApiResult)v0;
                        apiResult.extractResult();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final /* synthetic */ Object signOut$logout(AuthUseCase $this$signOut_u24logout, Continuation $completion) {
        $this$signOut_u24logout.logout();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$signOut$logout(AuthUseCase $receiver, Continuation $completion) {
        return OmhAuthClientImpl.signOut$logout($receiver, $completion);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/omh/android/auth/nongms/presentation/OmhAuthClientImpl$Builder;", "Lcom/omh/android/auth/api/OmhAuthClient$Builder;", "clientId", "", "(Ljava/lang/String;)V", "authScope", "addScope", "scope", "build", "Lcom/omh/android/auth/api/OmhAuthClient;", "context", "Landroid/content/Context;", "auth-api-non-gms_release"})
    public static final class Builder
    implements OmhAuthClient.Builder {
        @NotNull
        private String clientId;
        @NotNull
        private String authScope;

        public Builder(@NotNull String clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            this.clientId = clientId;
            this.authScope = "";
        }

        @NotNull
        public final Builder addScope(@NotNull String scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.authScope = this.authScope + ' ' + scope;
            ((Object)StringsKt.trim((CharSequence)this.authScope)).toString();
            return this;
        }

        @NotNull
        public OmhAuthClient build(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new OmhAuthClientImpl(this.clientId, this.authScope, context);
        }
    }
}

