/*
 * Decompiled with CFR 0.152.
 */
package com.omh.android.auth.nongms.factories;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.omh.android.auth.nongms.data.login.AuthRepositoryImpl;
import com.omh.android.auth.nongms.data.user.UserRepositoryImpl;
import com.omh.android.auth.nongms.domain.auth.AuthRepository;
import com.omh.android.auth.nongms.domain.auth.AuthUseCase;
import com.omh.android.auth.nongms.domain.user.ProfileUseCase;
import com.omh.android.auth.nongms.domain.user.UserRepository;
import com.omh.android.auth.nongms.presentation.redirect.RedirectViewModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/omh/android/auth/nongms/factories/ViewModelFactory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "()V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "extras", "Landroidx/lifecycle/viewmodel/CreationExtras;", "(Ljava/lang/Class;Landroidx/lifecycle/viewmodel/CreationExtras;)Landroidx/lifecycle/ViewModel;", "auth-api-non-gms_release"})
public final class ViewModelFactory
implements ViewModelProvider.Factory {
    @NotNull
    public <T extends ViewModel> T create(@NotNull Class<T> modelClass, @NotNull CreationExtras extras) {
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Object object = extras.get(ViewModelProvider.AndroidViewModelFactory.APPLICATION_KEY);
        if (object == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Application application = (Application)object;
        AuthRepository authRepository = AuthRepositoryImpl.Companion.getAuthRepository$default(AuthRepositoryImpl.Companion, (Context)application, null, 2, null);
        AuthUseCase authUseCase = AuthUseCase.Companion.createAuthUseCase(authRepository);
        UserRepository userRepository = UserRepositoryImpl.Companion.getUserRepository$default(UserRepositoryImpl.Companion, (Context)application, null, 2, null);
        ProfileUseCase profileUseCase = ProfileUseCase.Companion.createUserProfileUseCase(userRepository);
        return (T)((Object)new RedirectViewModel(authUseCase, profileUseCase));
    }
}

