/*
 * Decompiled with CFR 0.152.
 */
package com.omh.android.auth.nongms.domain.utils;

import android.util.Base64;
import com.omh.android.auth.nongms.domain.utils.Pkce;
import java.security.MessageDigest;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0002J\b\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/omh/android/auth/nongms/domain/utils/PkceImpl;", "Lcom/omh/android/auth/nongms/domain/utils/Pkce;", "()V", "codeVerifier", "", "getCodeVerifier", "()Ljava/lang/String;", "generateCodeChallenge", "generateCodeVerifier", "getEncoding", "", "Companion", "auth-api-non-gms_release"})
public final class PkceImpl
implements Pkce {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String codeVerifier = this.generateCodeVerifier();
    private static final int SIXTYFOUR_BIT_SIZE = 64;

    @Override
    @NotNull
    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    private final int getEncoding() {
        return 11;
    }

    private final String generateCodeVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[64];
        secureRandom.nextBytes(bytes);
        String string = Base64.encodeToString((byte[])bytes, (int)this.getEncoding());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(bytes, getEncoding())");
        return string;
    }

    @Override
    @NotNull
    public String generateCodeChallenge() {
        String string = this.getCodeVerifier();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(bytes);
        byte[] digest = messageDigest.digest();
        String string2 = Base64.encodeToString((byte[])digest, (int)this.getEncoding());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(digest, getEncoding())");
        return string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/omh/android/auth/nongms/domain/utils/PkceImpl$Companion;", "", "()V", "SIXTYFOUR_BIT_SIZE", "", "auth-api-non-gms_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

