/*
 * Decompiled with CFR 0.152.
 */
package com.omh.android.auth.nongms.data.user.datasource;

import android.content.SharedPreferences;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.omh.android.auth.api.models.OmhUserProfile;
import com.omh.android.auth.nongms.data.user.datasource.UserDataSource;
import java.util.Collection;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/omh/android/auth/nongms/data/user/datasource/GoogleUserDataSource;", "Lcom/omh/android/auth/nongms/data/user/datasource/UserDataSource;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "getProfileData", "Lcom/omh/android/auth/api/models/OmhUserProfile;", "handleIdToken", "", "idToken", "", "clientId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "auth-api-non-gms_release"})
public final class GoogleUserDataSource
implements UserDataSource {
    @NotNull
    private final SharedPreferences sharedPreferences;

    public GoogleUserDataSource(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    @Nullable
    public Object handleIdToken(@NotNull String idToken, @NotNull String clientId, @NotNull Continuation<? super Unit> $completion) {
        GoogleIdTokenVerifier verifier = new GoogleIdTokenVerifier.Builder((HttpTransport)new NetHttpTransport.Builder().build(), (JsonFactory)GsonFactory.getDefaultInstance()).setAudience((Collection)Collections.singletonList(clientId)).build();
        GoogleIdToken googleIdToken = verifier.verify(idToken);
        Intrinsics.checkNotNullExpressionValue((Object)googleIdToken, (String)"verifier.verify(idToken)");
        GoogleIdToken googleIdToken2 = googleIdToken;
        GoogleIdToken.Payload payload = googleIdToken2.getPayload();
        Intrinsics.checkNotNullExpressionValue((Object)payload, (String)"googleIdToken.payload");
        GoogleIdToken.Payload payload2 = payload;
        String string = payload2.getEmail();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"payload.email");
        String email = string;
        String name = String.valueOf(payload2.get((Object)"given_name"));
        String surname = String.valueOf(payload2.get((Object)"family_name"));
        String picture = String.valueOf(payload2.get((Object)"picture"));
        String id = payload2.getSubject();
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$handleIdToken_u24lambda_u240 = editor$iv;
        boolean bl = false;
        $this$handleIdToken_u24lambda_u240.putString("given_name", name);
        $this$handleIdToken_u24lambda_u240.putString("family_name", surname);
        $this$handleIdToken_u24lambda_u240.putString("email", email);
        $this$handleIdToken_u24lambda_u240.putString("picture", picture);
        $this$handleIdToken_u24lambda_u240.putString("id", id);
        editor$iv.apply();
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public OmhUserProfile getProfileData() {
        String name = this.sharedPreferences.getString("given_name", null);
        String email = this.sharedPreferences.getString("email", null);
        String surname = this.sharedPreferences.getString("family_name", null);
        String picture = this.sharedPreferences.getString("picture", null);
        if (name == null || email == null || surname == null) {
            return null;
        }
        return new OmhUserProfile(name, surname, email, picture);
    }
}

