/*
 * Decompiled with CFR 0.152.
 */
package com.omh.android.auth.nongms.data.login.datasource;

import android.content.SharedPreferences;
import android.net.Uri;
import com.omh.android.auth.nongms.data.login.GoogleAuthREST;
import com.omh.android.auth.nongms.data.login.datasource.AuthDataSource;
import com.omh.android.auth.nongms.data.login.models.AuthTokenResponse;
import com.omh.android.auth.nongms.domain.models.ApiResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J7\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u001b\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lcom/omh/android/auth/nongms/data/login/datasource/GoogleAuthDataSource;", "Lcom/omh/android/auth/nongms/data/login/datasource/AuthDataSource;", "authService", "Lcom/omh/android/auth/nongms/data/login/GoogleAuthREST;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Lcom/omh/android/auth/nongms/data/login/GoogleAuthREST;Landroid/content/SharedPreferences;)V", "buildLoginUrl", "Landroid/net/Uri;", "scopes", "", "clientId", "codeChallenge", "redirectUri", "clearData", "", "getRefreshToken", "getToken", "tokenType", "Lcom/omh/android/auth/nongms/domain/models/ApiResult;", "Lcom/omh/android/auth/nongms/data/login/models/AuthTokenResponse;", "authCode", "codeVerifier", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshAccessToken", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "revokeToken", "token", "storeToken", "Companion", "auth-api-non-gms_release"})
public final class GoogleAuthDataSource
implements AuthDataSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoogleAuthREST authService;
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private static final String AUTH_URI = "https://accounts.google.com/o/oauth2/auth";
    @NotNull
    private static final String CODE_VALUE = "code";

    public GoogleAuthDataSource(@NotNull GoogleAuthREST authService, @NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.authService = authService;
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    @Nullable
    public Object getToken(@NotNull String clientId, @NotNull String authCode, @NotNull String redirectUri, @NotNull String codeVerifier, @NotNull Continuation<? super ApiResult<AuthTokenResponse>> $completion) {
        return GoogleAuthREST.DefaultImpls.getToken$default(this.authService, clientId, authCode, redirectUri, codeVerifier, null, $completion, 16, null);
    }

    @Override
    @NotNull
    public Uri buildLoginUrl(@NotNull String scopes, @NotNull String clientId, @NotNull String codeChallenge, @NotNull String redirectUri) {
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)codeChallenge, (String)"codeChallenge");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        String $this$toUri$iv = AUTH_URI;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
        Uri uri2 = uri.buildUpon().appendQueryParameter("scope", scopes).appendQueryParameter("response_type", CODE_VALUE).appendQueryParameter("redirect_uri", redirectUri).appendQueryParameter("client_id", clientId).appendQueryParameter("code_challenge_method", "S256").appendQueryParameter("code_challenge", codeChallenge).build();
        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"AUTH_URI.toUri().buildUp\u2026nge)\n            .build()");
        return uri2;
    }

    @Override
    public void storeToken(@NotNull String tokenType, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$storeToken_u24lambda_u240 = editor$iv;
        boolean bl = false;
        $this$storeToken_u24lambda_u240.putString(tokenType, token);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public String getToken(@NotNull String tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return this.sharedPreferences.getString(tokenType, null);
    }

    private final String getRefreshToken() {
        return this.sharedPreferences.getString("refreshtoken", null);
    }

    @Override
    @Nullable
    public Object refreshAccessToken(@NotNull String clientId, @NotNull Continuation<? super ApiResult<AuthTokenResponse>> $completion) {
        String string = this.getRefreshToken();
        if (string == null) {
            return new ApiResult.Error.RuntimeError(new IllegalStateException("No refresh token"));
        }
        String refreshToken = string;
        return GoogleAuthREST.DefaultImpls.refreshToken$default(this.authService, clientId, refreshToken, null, $completion, 4, null);
    }

    @Override
    @Nullable
    public Object revokeToken(@NotNull String token, @NotNull Continuation<? super ApiResult<Unit>> $completion) {
        return this.authService.revokeToken(token, $completion);
    }

    @Override
    public void clearData() {
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor p0 = editor$iv;
        boolean bl = false;
        p0.clear();
        editor$iv.apply();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/omh/android/auth/nongms/data/login/datasource/GoogleAuthDataSource$Companion;", "", "()V", "AUTH_URI", "", "CODE_VALUE", "auth-api-non-gms_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

