/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.content.Context;
import com.adtbid.sdk.AdTimingAds;
import com.adtbid.sdk.InitCallback;
import com.adtbid.sdk.utils.error.AdTimingError;
import java.util.HashSet;
import java.util.Set;

public class AdTimingSingleTon
implements InitCallback {
    private volatile InitState mInitState = InitState.NOT_INIT;
    private volatile Set<AdTimingInitCallback> initCallbacks = new HashSet<AdTimingInitCallback>();

    public void onSuccess() {
        this.mInitState = InitState.INIT_SUCCESS;
        for (AdTimingInitCallback initCallback : this.initCallbacks) {
            if (initCallback == null) continue;
            initCallback.onSuccess();
        }
        this.initCallbacks.clear();
    }

    public void onError(AdTimingError adTimingError) {
        this.mInitState = InitState.INIT_FAIL;
        for (AdTimingInitCallback initCallback : this.initCallbacks) {
            if (initCallback == null) continue;
            initCallback.onError(adTimingError);
        }
        this.initCallbacks.clear();
    }

    private AdTimingSingleTon() {
    }

    public static AdTimingSingleTon getInstance() {
        return AdTimingHolder.INSTANCE;
    }

    public synchronized void initAdTiming(Context context, String appKey, AdTimingInitCallback callback) {
        switch (this.mInitState) {
            case NOT_INIT: {
                this.initCallbacks.add(callback);
                this.init(context, appKey);
                break;
            }
            case INIT_PENDING: {
                this.initCallbacks.add(callback);
                break;
            }
            case INIT_SUCCESS: {
                if (callback == null) break;
                callback.onSuccess();
                break;
            }
            case INIT_FAIL: {
                if (callback == null) break;
                callback.onError(new AdTimingError(109));
            }
        }
    }

    private void init(Context context, String appKey) {
        this.mInitState = InitState.INIT_PENDING;
        AdTimingAds.init((Context)context, (String)appKey, (InitCallback)this);
    }

    static enum InitState {
        NOT_INIT,
        INIT_PENDING,
        INIT_SUCCESS,
        INIT_FAIL;

    }

    static interface AdTimingInitCallback {
        public void onSuccess();

        public void onError(AdTimingError var1);
    }

    private static class AdTimingHolder {
        private static final AdTimingSingleTon INSTANCE = new AdTimingSingleTon();

        private AdTimingHolder() {
        }
    }
}

