/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.adtbid.sdk.AdTimingAds;
import com.adtbid.sdk.nativead.Ad;
import com.adtbid.sdk.nativead.MediaView;
import com.adtbid.sdk.nativead.NativeAd;
import com.adtbid.sdk.nativead.NativeAdListener;
import com.adtbid.sdk.utils.error.AdTimingError;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomNativeEvent;
import com.openmediation.sdk.mobileads.AdTimingSingleTon;
import com.openmediation.sdk.nativead.AdIconView;
import com.openmediation.sdk.nativead.AdInfo;
import com.openmediation.sdk.nativead.NativeAdView;
import java.util.Map;

public class AdTimingNative
extends CustomNativeEvent
implements NativeAdListener {
    private static final String PAY_LOAD = "pay_load";
    private NativeAd mNativeAd;
    private Ad mAd;

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        AdTimingAds.setGDPRConsent((boolean)consent);
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        AdTimingAds.setAgeRestricted((boolean)value);
    }

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        AdTimingAds.setAgeRestricted((boolean)restricted);
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        AdTimingAds.setUserAge((int)age);
    }

    public void setUserGender(Context context, String gender) {
        super.setUserGender(context, gender);
        AdTimingAds.setUserGender((String)gender);
    }

    public void loadAd(final Activity activity, final Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        String appKey = config.get("AppKey");
        AdTimingSingleTon.getInstance().initAdTiming((Context)activity, appKey, new AdTimingSingleTon.AdTimingInitCallback(){

            @Override
            public void onSuccess() {
                AdTimingNative.this.loadNativeAd(activity, config);
            }

            @Override
            public void onError(AdTimingError error) {
                AdTimingNative.this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Native", (String)AdTimingNative.this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
            }
        });
    }

    public void registerNativeView(NativeAdView adView) {
        try {
            if (this.isDestroyed || this.mAd == null) {
                return;
            }
            com.adtbid.sdk.nativead.NativeAdView adnNativeAdView = new com.adtbid.sdk.nativead.NativeAdView(adView.getContext());
            if (adView.getMediaView() != null) {
                com.openmediation.sdk.nativead.MediaView mediaView = adView.getMediaView();
                mediaView.removeAllViews();
                MediaView adnMediaView = new MediaView(adView.getContext());
                mediaView.addView((View)adnMediaView);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(13);
                adnMediaView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                adnNativeAdView.setMediaView(adnMediaView);
            }
            if (adView.getAdIconView() != null) {
                AdIconView iconView = adView.getAdIconView();
                iconView.removeAllViews();
                com.adtbid.sdk.nativead.AdIconView adnIconView = new com.adtbid.sdk.nativead.AdIconView(adView.getContext());
                iconView.addView((View)adnIconView);
                adnIconView.getLayoutParams().width = -1;
                adnIconView.getLayoutParams().height = -1;
                adnNativeAdView.setAdIconView(adnIconView);
            }
            adnNativeAdView.setCallToActionView(adView.getCallToActionView());
            adnNativeAdView.setTitleView(adView.getTitleView());
            adnNativeAdView.setDescView(adView.getDescView());
            adView.addView((View)adnNativeAdView);
            this.mNativeAd.registerNativeAdView(adnNativeAdView);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getMediation() {
        return 1;
    }

    public void destroy(Activity activity) {
        if (this.mNativeAd != null) {
            this.mNativeAd.destroy();
            this.mNativeAd = null;
        }
        this.isDestroyed = true;
    }

    private void loadNativeAd(Activity activity, Map<String, String> config) {
        String payload = "";
        if (config.containsKey(PAY_LOAD)) {
            payload = config.get(PAY_LOAD);
        }
        if (this.mNativeAd != null) {
            this.mNativeAd.loadAdWithPayload(payload);
            return;
        }
        this.mNativeAd = new NativeAd((Context)activity, this.mInstancesKey);
        this.mNativeAd.setAdListener((NativeAdListener)this);
        this.mNativeAd.loadAdWithPayload(payload);
    }

    public void onNativeAdReady(String placementId, Ad ad) {
        if (!this.isDestroyed) {
            if (ad == null) {
                this.onInsError(AdapterErrorBuilder.buildLoadCheckError((String)"Native", (String)this.mAdapterName, (String)"NativeAd Load Failed"));
                return;
            }
            this.mAd = ad;
            AdInfo adInfo = new AdInfo();
            adInfo.setDesc(ad.getDescription());
            adInfo.setType(this.getMediation());
            adInfo.setTitle(ad.getTitle());
            adInfo.setCallToActionText(ad.getCTA());
            this.onInsReady(adInfo);
        }
    }

    public void onNativeAdFailed(String placementId, AdTimingError error) {
        if (!this.isDestroyed) {
            this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Native", (String)this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
        }
    }

    public void onNativeAdClicked(String s) {
        if (!this.isDestroyed) {
            this.onInsClicked();
        }
    }

    public void onNativeAdShowFailed(String s, AdTimingError adTimingError) {
    }
}

