/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import com.adtbid.sdk.AdTimingAds;
import com.adtbid.sdk.banner.AdSize;
import com.adtbid.sdk.banner.BannerAd;
import com.adtbid.sdk.banner.BannerAdListener;
import com.adtbid.sdk.utils.error.AdTimingError;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomBannerEvent;
import com.openmediation.sdk.mobileads.AdTimingSingleTon;
import java.util.Map;

public class AdTimingBanner
extends CustomBannerEvent
implements BannerAdListener {
    private static final String TAG = "OM-AdTiming: ";
    private static final String PAY_LOAD = "pay_load";
    private BannerAd mBannerAd;

    public int getMediation() {
        return 1;
    }

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        AdTimingAds.setGDPRConsent((boolean)consent);
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        AdTimingAds.setAgeRestricted((boolean)value);
    }

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        AdTimingAds.setAgeRestricted((boolean)restricted);
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        AdTimingAds.setUserAge((int)age);
    }

    public void setUserGender(Context context, String gender) {
        super.setUserGender(context, gender);
        AdTimingAds.setUserGender((String)gender);
    }

    public void loadAd(final Activity activity, final Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        String appKey = config.get("AppKey");
        AdTimingSingleTon.getInstance().initAdTiming((Context)activity, appKey, new AdTimingSingleTon.AdTimingInitCallback(){

            @Override
            public void onSuccess() {
                AdTimingBanner.this.loadBanner(activity, config);
            }

            @Override
            public void onError(AdTimingError adTimingError) {
                AdTimingBanner.this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)AdTimingBanner.this.mAdapterName, (int)adTimingError.getCode(), (String)adTimingError.getMessage()));
            }
        });
    }

    public void destroy(Activity activity) {
        if (this.mBannerAd != null) {
            this.mBannerAd.destroy();
            this.mBannerAd = null;
        }
        this.isDestroyed = true;
    }

    private void loadBanner(Activity activity, Map<String, String> config) {
        String payload = "";
        if (config.containsKey(PAY_LOAD)) {
            payload = config.get(PAY_LOAD);
        }
        if (this.mBannerAd != null) {
            this.mBannerAd.loadAdWithPayload(payload);
            return;
        }
        this.mBannerAd = new BannerAd((Context)activity, this.mInstancesKey);
        this.mBannerAd.setAdListener((BannerAdListener)this);
        AdSize adSize = this.getAdSize((Context)activity, config);
        this.mBannerAd.setAdSize(adSize);
        this.mBannerAd.loadAdWithPayload(payload);
    }

    public void onBannerAdReady(String placementId, View view) {
        if (!this.isDestroyed) {
            this.onInsReady(view);
        }
    }

    public void onBannerAdFailed(String placementId, AdTimingError error) {
        if (!this.isDestroyed) {
            this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)this.mAdapterName, (int)error.getCode(), (String)error.getMessage()));
        }
    }

    public void onBannerAdClicked(String placementId) {
        if (!this.isDestroyed) {
            this.onInsClicked();
        }
    }

    public void onBannerAdShowFailed(String placementId, AdTimingError error) {
    }

    private AdSize getAdSize(Context context, Map<String, String> config) {
        String bannerDesc;
        switch (bannerDesc = this.getBannerDesc(config)) {
            case "LEADERBOARD": {
                return AdSize.LEADERBOARD;
            }
            case "RECTANGLE": {
                return AdSize.MEDIUM_RECTANGLE;
            }
            case "SMART": {
                if (AdTimingBanner.isLargeScreen((Context)context)) {
                    return AdSize.LEADERBOARD;
                }
                return AdSize.BANNER;
            }
        }
        return AdSize.BANNER;
    }
}

