/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.mathmlsupport;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.OutputDeviceGraphicsDrawer;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.simple.extend.ReplacedElementScaleHelper;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.List;
import net.sourceforge.jeuclid.DOMBuilder;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MathMLImage
implements SVGDrawer.SVGImage {
    private final JEuclidView _view;
    private final DocumentElement _mathDoc;
    private final double _dotsPerPixel;
    private final Box _box;
    private final MathLayoutContext _context = new MathLayoutContext();

    public MathMLImage(Element mathMlElement, Box box, double cssWidth, double cssHeight, double cssMaxWidth, double cssMaxHeight, double dotsPerPixel, List<String> fonts) {
        this._box = box;
        this._dotsPerPixel = dotsPerPixel;
        this._mathDoc = DOMBuilder.getInstance().createJeuclidDom((Node)mathMlElement);
        this._context.setParameter(Parameter.FONTS_SERIF, fonts);
        this._context.setParameter(Parameter.FONTS_DOUBLESTRUCK, fonts);
        this._context.setParameter(Parameter.FONTS_FRAKTUR, fonts);
        this._context.setParameter(Parameter.FONTS_MONOSPACED, fonts);
        this._context.setParameter(Parameter.FONTS_SANSSERIF, fonts);
        this._context.setParameter(Parameter.FONTS_SCRIPT, fonts);
        this._context.setParameter(Parameter.MATHSIZE, Float.valueOf(16.0f));
        this._view = new JEuclidView((Node)this._mathDoc, (LayoutContext)this._context, null);
    }

    private double getViewWidthInOutputDeviceDots() {
        return (double)this._view.getWidth() * this._dotsPerPixel;
    }

    private double getViewHeightInOutputDeviceDots() {
        return (double)(this._view.getAscentHeight() + this._view.getDescentHeight()) * this._dotsPerPixel;
    }

    public int getIntrinsicWidth() {
        return (int)this.getViewWidthInOutputDeviceDots();
    }

    public int getIntrinsicHeight() {
        return (int)this.getViewHeightInOutputDeviceDots();
    }

    public void drawSVG(OutputDevice outputDevice, RenderingContext ctx, double x, double y) {
        Rectangle contentBounds = this._box.getContentAreaEdge(this._box.getAbsX(), this._box.getAbsY(), (CssContext)ctx);
        final AffineTransform scale2 = ReplacedElementScaleHelper.createScaleTransform((double)this._dotsPerPixel, (Rectangle)contentBounds, (float)this._view.getWidth(), (float)(this._view.getAscentHeight() + this._view.getDescentHeight()));
        final AffineTransform inverse2 = ReplacedElementScaleHelper.inverseOrNull((AffineTransform)scale2);
        final boolean transformed2 = scale2 != null && inverse2 != null;
        outputDevice.drawWithGraphics((float)x, (float)y, (float)((double)contentBounds.width / this._dotsPerPixel), (float)((double)contentBounds.height / this._dotsPerPixel), new OutputDeviceGraphicsDrawer(){

            public void render(Graphics2D g2d) {
                if (transformed2) {
                    g2d.transform(scale2);
                }
                MathMLImage.this._view.draw(g2d, 0.0f, MathMLImage.this._view.getAscentHeight());
                if (transformed2) {
                    g2d.transform(inverse2);
                }
            }
        });
    }

    public static class MathLayoutContext
    extends LayoutContextImpl {
        private static final long serialVersionUID = 1L;
    }
}

