// File generated from our OpenAPI spec by Stainless.

package com.openai.services.blocking

import com.openai.core.ClientOptions
import com.openai.services.blocking.beta.AssistantService
import com.openai.services.blocking.beta.ChatKitService
import com.openai.services.blocking.beta.RealtimeService
import com.openai.services.blocking.beta.ThreadService
import java.util.function.Consumer

interface BetaService {

    /**
     * Returns a view of this service that provides access to raw HTTP responses for each method.
     */
    fun withRawResponse(): WithRawResponse

    /**
     * Returns a view of this service with the given option modifications applied.
     *
     * The original service is not modified.
     */
    fun withOptions(modifier: Consumer<ClientOptions.Builder>): BetaService

    @Deprecated(
        "Realtime has now launched and is generally available. The old beta API is now deprecated."
    )
    fun realtime(): RealtimeService

    fun chatkit(): ChatKitService

    fun assistants(): AssistantService

    @Deprecated("The Assistants API is deprecated in favor of the Responses API")
    fun threads(): ThreadService

    /** A view of [BetaService] that provides access to raw HTTP responses for each method. */
    interface WithRawResponse {

        /**
         * Returns a view of this service with the given option modifications applied.
         *
         * The original service is not modified.
         */
        fun withOptions(modifier: Consumer<ClientOptions.Builder>): BetaService.WithRawResponse

        @Deprecated(
            "Realtime has now launched and is generally available. The old beta API is now deprecated."
        )
        fun realtime(): RealtimeService.WithRawResponse

        fun chatkit(): ChatKitService.WithRawResponse

        fun assistants(): AssistantService.WithRawResponse

        @Deprecated("The Assistants API is deprecated in favor of the Responses API")
        fun threads(): ThreadService.WithRawResponse
    }
}
