/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.prefixmapper.PrefixFileReader;
import java.util.Locale;

public class PhoneNumberToCarrierMapper {
    private static PhoneNumberToCarrierMapper instance = null;
    private static final String MAPPING_DATA_DIRECTORY = "/com/google/i18n/phonenumbers/carrier/data/";
    private PrefixFileReader prefixFileReader = null;
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();

    PhoneNumberToCarrierMapper(String phonePrefixDataDirectory) {
        PhoneNumberToCarrierMapper phoneNumberToCarrierMapper = this;
        this.prefixFileReader = new PrefixFileReader(phoneNumberToCarrierMapper.phoneUtil.getContext(), phonePrefixDataDirectory);
    }

    public static synchronized PhoneNumberToCarrierMapper getInstance() {
        if (instance == null) {
            instance = new PhoneNumberToCarrierMapper(MAPPING_DATA_DIRECTORY);
        }
        return instance;
    }

    public String getNameForValidNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        String langStr = languageCode.getLanguage();
        String scriptStr = "";
        String regionStr = languageCode.getCountry();
        return this.prefixFileReader.getDescriptionForNumber(number, langStr, scriptStr, regionStr);
    }

    public String getNameForNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        PhoneNumberUtil.PhoneNumberType numberType = this.phoneUtil.getNumberType(number);
        if (this.isMobile(numberType)) {
            return this.getNameForValidNumber(number, languageCode);
        }
        return "";
    }

    public String getSafeDisplayName(Phonenumber.PhoneNumber number, Locale languageCode) {
        if (this.phoneUtil.isMobileNumberPortableRegion(this.phoneUtil.getRegionCodeForNumber(number))) {
            return "";
        }
        return this.getNameForNumber(number, languageCode);
    }

    private boolean isMobile(PhoneNumberUtil.PhoneNumberType numberType) {
        return numberType == PhoneNumberUtil.PhoneNumberType.MOBILE || numberType == PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE || numberType == PhoneNumberUtil.PhoneNumberType.PAGER;
    }
}

