/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm.core.helper;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.oogbox.support.orm.BaseModel;
import com.oogbox.support.orm.core.data.ORecord;
import com.oogbox.support.orm.core.data.ORecordValue;
import com.oogbox.support.orm.core.factory.BaseModelCursor;
import com.oogbox.support.orm.core.types.OManyToMany;
import com.oogbox.support.orm.core.types.helper.OFieldType;
import java.util.ArrayList;
import java.util.List;

public class M2MTable
extends BaseModel {
    private BaseModel baseModel;
    private OManyToMany baseColumn;
    private BaseModel relModel;

    public M2MTable(Context context, BaseModel baseModel, OFieldType baseColumn) {
        super(context);
        this.baseModel = baseModel;
        this.baseColumn = (OManyToMany)baseColumn;
        this.relModel = this.createModel(baseColumn.getRefModel());
    }

    @Override
    public String getTableName() {
        return this.getRelTableName();
    }

    public String getBaseColumnName() {
        return this.baseColumn.getBaseColumnName() != null ? this.baseColumn.getBaseColumnName() : this.baseModel.getTableName() + "_id";
    }

    public String getRelColumnName() {
        return this.baseColumn.getRelColumnName() != null ? this.baseColumn.getRelColumnName() : this.relModel.getTableName() + "_id";
    }

    public String getRelTableName() {
        return this.baseColumn.getRelTableName() != null ? this.baseColumn.getRelTableName() : this.baseModel.getTableName() + "_" + this.relModel.getTableName() + "_rel";
    }

    public String createStatement() {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE IF NOT EXISTS ").append(this.getRelTableName());
        sql.append(" ( ");
        sql.append(this.getBaseColumnName()).append(" INTEGER ");
        sql.append("REFERENCES ").append(this.baseModel.getTableName()).append(" ON DELETE CASCADE,");
        sql.append(this.getRelColumnName()).append(" INTEGER ");
        sql.append("REFERENCES ").append(this.relModel.getTableName()).append(" ON DELETE CASCADE");
        sql.append(")");
        return sql.toString();
    }

    public List<ORecord> readAll(Integer baseRecordId) {
        ArrayList<ORecord> records = new ArrayList<ORecord>();
        SQLiteDatabase db = this.getReadableDatabase();
        String relSQL = "SELECT " + this.getRelColumnName() + " FROM " + this.getRelTableName() + " WHERE " + this.getBaseColumnName() + " = " + baseRecordId;
        BaseModelCursor cr = (BaseModelCursor)db.query(this.relModel.getTableName(), null, "_id in (" + relSQL + ")", null, null, null, null);
        if (cr.moveToFirst()) {
            do {
                ORecord record = ORecord.fromCursor((Cursor)cr);
                record.setModel(this.relModel);
                records.add(record);
            } while (cr.moveToNext());
        }
        cr.close();
        db.close();
        return records;
    }

    public int insert(int baseId, int relId) {
        ORecordValue value = new ORecordValue();
        value.put(this.getBaseColumnName(), baseId);
        value.put(this.getRelColumnName(), relId);
        return this.create(value);
    }

    public int insert(int baseId, ORecordValue relRecord) {
        return this.insert(baseId, this.relModel.create(relRecord));
    }

    public void removeRelRecord(Integer relId) {
        this.relModel.delete(relId);
    }

    public void removeAllRelation(int baseId) {
        this.delete(this.getBaseColumnName() + " = ?", new String[]{baseId + ""});
    }
}

