/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.oogbox.support.orm.DataResolver;
import com.oogbox.support.orm.core.annotation.DataModel;
import com.oogbox.support.orm.core.data.ORecord;
import com.oogbox.support.orm.core.data.ORecordValue;
import com.oogbox.support.orm.core.data.RelationOperation;
import com.oogbox.support.orm.core.data.RelationValue;
import com.oogbox.support.orm.core.helper.M2MTable;
import com.oogbox.support.orm.core.helper.SQLBuilder;
import com.oogbox.support.orm.core.helper.SQLiteHelper;
import com.oogbox.support.orm.core.types.ODateTime;
import com.oogbox.support.orm.core.types.OInteger;
import com.oogbox.support.orm.core.types.OManyToMany;
import com.oogbox.support.orm.core.types.OManyToOne;
import com.oogbox.support.orm.core.types.OOneToMany;
import com.oogbox.support.orm.core.types.helper.OFieldType;
import com.oogbox.support.orm.utils.OOGDateUtils;
import com.oogbox.support.orm.utils.ObjectByteUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public abstract class BaseModel
extends SQLiteHelper {
    public static final String KEY_IGNORE_WRITE_DATE = "ignore_write_date";
    private String defaultNameField = "name";
    private OInteger _id = (OInteger)((OInteger)new OInteger("ID").autoIncrement()).primaryKey();
    private ODateTime _write_date = new ODateTime("Local Write Date");

    public BaseModel(Context context) {
        super(context);
    }

    public String getModelName() {
        DataModel dataModel = ((Object)((Object)this)).getClass().getAnnotation(DataModel.class);
        if (dataModel != null) {
            return dataModel.value();
        }
        return ((Object)((Object)this)).getClass().getSimpleName().toLowerCase();
    }

    public String getTableName() {
        String modelName = this.getModelName();
        if (modelName != null) {
            return modelName.replaceAll("\\.", "_");
        }
        return null;
    }

    protected void setDefaultNameField(String nameField) {
        this.defaultNameField = nameField;
    }

    public String getDefaultNameField() {
        return this.defaultNameField;
    }

    public OFieldType getColumn(String column) {
        try {
            Field field = ((Object)((Object)this)).getClass().getDeclaredField(column);
            field.setAccessible(true);
            OFieldType type = (OFieldType)field.get((Object)this);
            type.setName(field.getName());
            return type;
        }
        catch (Exception e) {
            try {
                Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(column);
                field.setAccessible(true);
                OFieldType type = (OFieldType)field.get((Object)this);
                type.setName(field.getName());
                return type;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public List<OFieldType> getColumns() {
        ArrayList<OFieldType> columns = new ArrayList<OFieldType>();
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(this.getParentFields(((Object)((Object)this)).getClass().getSuperclass()));
        fields.addAll(Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields()));
        for (Field field : fields) {
            if (!field.getType().getSuperclass().getCanonicalName().equals(OFieldType.class.getCanonicalName())) continue;
            field.setAccessible(true);
            try {
                OFieldType type = (OFieldType)field.get((Object)this);
                type.setName(field.getName());
                columns.add(type);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return columns;
    }

    private List<Field> getParentFields(Class cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (!cls.getCanonicalName().equals(BaseModel.class.getCanonicalName())) {
            fields.addAll(this.getParentFields(cls.getSuperclass()));
        }
        fields.addAll(Arrays.asList(cls.getDeclaredFields()));
        return fields;
    }

    public SQLBuilder getSQLBuilder() {
        return new SQLBuilder(this);
    }

    public List<ORecord> select() {
        return this.select(null, null);
    }

    public List<ORecord> select(String selection, String[] args) {
        ArrayList<ORecord> records = new ArrayList<ORecord>();
        Cursor cr = this.select(null, selection, args, null, null, null, null);
        if (cr.moveToFirst()) {
            do {
                ORecord record = ORecord.fromCursor(cr);
                record.setModel(this);
                records.add(record);
            } while (cr.moveToNext());
        }
        cr.close();
        return records;
    }

    public Cursor select(String[] columns, String selection, String[] args, String groupBy, String having, String orderBy, String limit) {
        SQLiteDatabase db = this.getReadableDatabase();
        return db.query(this.getTableName(), columns, selection, args, groupBy, having, orderBy, limit);
    }

    public ORecord browse(int _id) {
        ORecord record = null;
        Cursor cr = this.select(null, "_id = ?", new String[]{_id + ""}, null, null, null, null);
        if (cr.moveToFirst()) {
            record = ORecord.fromCursor(cr);
            record.setModel(this);
        }
        cr.close();
        return record;
    }

    public int create(ORecordValue value) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = value.toContentValues();
        HashMap<String, ORecordValue> m2oRelRecords = value.getM2ORelRecords();
        if (!m2oRelRecords.isEmpty()) {
            ORecordValue newValues = this.handleM2ORecords(m2oRelRecords);
            for (String key : newValues.keySet()) {
                values.put(key, newValues.getInt(key));
            }
        }
        int newId = Long.valueOf(db.insert(this.getTableName(), null, values)).intValue();
        HashMap<String, RelationValue> relationValue = value.getRelationValues();
        if (!relationValue.isEmpty()) {
            this.handleRelationRecords(relationValue, newId);
        }
        db.close();
        return newId;
    }

    public int update(ORecordValue value, int _id) {
        return this.update(value, "_id = ?", new String[]{_id + ""});
    }

    public int update(ORecordValue value, String selection, String[] args) {
        HashMap<String, ORecordValue> m2oRecords;
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = value.toContentValues();
        value.put("_write_date", OOGDateUtils.getUTCDate());
        if (value.containsKey(KEY_IGNORE_WRITE_DATE)) {
            value.remove(KEY_IGNORE_WRITE_DATE);
            value.remove("_write_date");
        }
        if (!(m2oRecords = value.getM2ORelRecords()).isEmpty()) {
            ORecordValue newValues = this.handleM2ORecords(m2oRecords);
            for (String key : newValues.keySet()) {
                values.put(key, newValues.getInt(key));
            }
        }
        int count = db.update(this.getTableName(), values, selection, args);
        HashMap<String, RelationValue> relationValue = value.getRelationValues();
        if (!relationValue.isEmpty()) {
            this.handleRelationRecords(relationValue, this.getIds(selection, args));
        }
        db.close();
        return count;
    }

    public int delete(int _id) {
        return this.delete("_id = ? ", new String[]{_id + ""});
    }

    public int delete(String selection, String[] args) {
        SQLiteDatabase db = this.getWritableDatabase();
        int count = db.delete(this.getTableName(), selection, args);
        db.close();
        return count;
    }

    public int count(String selection, String[] args) {
        int count = 0;
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cr = db.query(this.getTableName(), new String[]{"count(*) as total"}, selection, args, null, null, null);
        if (cr.moveToFirst()) {
            ORecord record = ORecord.fromCursor(cr);
            if (record.containsKey("total")) {
                count = record.getInt("total");
            }
            cr.close();
        }
        return count;
    }

    public List<ORecord> nameSearch(String term, String operator, String orderBy) {
        String[] stringArray;
        OFieldType column = this.getColumn(this.getDefaultNameField());
        if (column == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "_id";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = column.getFieldName();
            stringArray = stringArray3;
            stringArray3[1] = "_id";
        }
        String[] projections = stringArray;
        String selection = String.format("%s %s ?", this.getDefaultNameField(), operator);
        String[] args = new String[]{operator.equals("like") ? term + "%" : term};
        Cursor cr = this.select(projections, selection, args, null, null, orderBy, null);
        ArrayList<ORecord> records = new ArrayList<ORecord>();
        if (cr.moveToFirst()) {
            do {
                ORecord record;
                if ((record = ORecord.fromCursor(cr)).size() == 1) {
                    record.put("name", String.format(Locale.getDefault(), "%s, %d", this.getModelName(), record.getInt("_id")));
                }
                record.setModel(this);
                records.add(record);
            } while (cr.moveToNext());
        }
        cr.close();
        return records;
    }

    public Integer[] getIds(String selection, String[] args) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cr = db.query(this.getTableName(), new String[]{"_id"}, selection, args, null, null, null);
        if (cr.moveToFirst()) {
            do {
                ids.add(cr.getInt(0));
            } while (cr.moveToNext());
        }
        cr.close();
        db.close();
        return ids.toArray(new Integer[ids.size()]);
    }

    public BaseModel createModel(Class<? extends BaseModel> model) {
        try {
            Constructor<? extends BaseModel> constructor = model.getConstructor(Context.class);
            return constructor.newInstance(this.getContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ORecordValue handleM2ORecords(HashMap<String, ORecordValue> values) {
        ORecordValue newRecordValue = new ORecordValue();
        for (String key : values.keySet()) {
            BaseModel refModel;
            OFieldType column = this.getColumn(key);
            if (column == null || !(column instanceof OManyToOne) || (refModel = this.createModel(column.getRefModel())) == null) continue;
            int refId = refModel.create(values.get(key));
            newRecordValue.put(key, refId);
        }
        return newRecordValue;
    }

    private void handleRelationRecords(HashMap<String, RelationValue> relationValueHashMap, Integer ... recordIds) {
        for (String key : relationValueHashMap.keySet()) {
            RelationValue value = relationValueHashMap.get(key);
            OFieldType column = this.getColumn(key);
            if (column instanceof OOneToMany) {
                this.manageO2MRelValue(column, value, recordIds);
            }
            if (!(column instanceof OManyToMany)) continue;
            this.manageM2MRelValue(column, value, recordIds);
        }
    }

    private void manageO2MRelValue(OFieldType column, RelationValue value, Integer ... recordIds) {
        BaseModel refModel = this.createModel(column.getRefModel());
        String refColumn = column.getRefColumn();
        for (RelationOperation key : value.getValues().keySet()) {
            Integer[] integerArray = recordIds;
            int n = integerArray.length;
            block6: for (int i = 0; i < n; ++i) {
                int id = integerArray[i];
                switch (key) {
                    case APPEND: {
                        for (Object obj : value.getValues().get((Object)key)) {
                            if (obj instanceof Integer) {
                                refModel.update(new ORecordValue().add(refColumn, id), (Integer)obj);
                            }
                            if (!(obj instanceof ORecordValue)) continue;
                            ORecordValue refRecord = (ORecordValue)obj;
                            refRecord.put(refColumn, id);
                            refModel.create(refRecord);
                        }
                        continue block6;
                    }
                    case REMOVE: {
                        for (Object obj : value.getValues().get((Object)key)) {
                            if (!(obj instanceof Integer)) continue;
                            refModel.delete((Integer)obj);
                        }
                        continue block6;
                    }
                    case REPLACE: 
                    case SET_NULL: {
                        ORecordValue setNull = new ORecordValue();
                        setNull.put(refColumn, null);
                        refModel.update(setNull, refColumn + " = ?", new String[]{id + ""});
                        if (key != RelationOperation.REPLACE) continue block6;
                        for (Object obj : value.getValues().get((Object)key)) {
                            if (obj instanceof Integer) {
                                refModel.update(new ORecordValue().add(refColumn, id), (Integer)obj);
                            }
                            if (!(obj instanceof ORecordValue)) continue;
                            ORecordValue refRecord = (ORecordValue)obj;
                            refRecord.put(refColumn, id);
                            refModel.create(refRecord);
                        }
                        continue block6;
                    }
                }
            }
        }
    }

    private void manageM2MRelValue(OFieldType column, RelationValue value, Integer ... recordIds) {
        M2MTable m2MTable = new M2MTable(this.getContext(), this, column);
        for (RelationOperation key : value.getValues().keySet()) {
            Integer[] integerArray = recordIds;
            int n = integerArray.length;
            block7: for (int i = 0; i < n; ++i) {
                int id = integerArray[i];
                switch (key) {
                    case APPEND: {
                        for (Object obj : value.getValues().get((Object)key)) {
                            if (obj instanceof Integer) {
                                m2MTable.insert(id, (Integer)obj);
                            }
                            if (!(obj instanceof ORecordValue)) continue;
                            m2MTable.insert(id, (ORecordValue)obj);
                        }
                        continue block7;
                    }
                    case REMOVE: {
                        for (Object obj : value.getValues().get((Object)key)) {
                            if (!(obj instanceof Integer)) continue;
                            m2MTable.removeRelRecord((Integer)obj);
                        }
                        continue block7;
                    }
                    case SET_NULL: {
                        continue block7;
                    }
                    case REPLACE: {
                        m2MTable.removeAllRelation(id);
                        if (key != RelationOperation.REPLACE) continue block7;
                        for (Object obj : value.getValues().get((Object)key)) {
                            if (obj instanceof Integer) {
                                m2MTable.insert(id, (Integer)obj);
                            }
                            if (!(obj instanceof ORecordValue)) continue;
                            m2MTable.insert(id, (ORecordValue)obj);
                        }
                        continue block7;
                    }
                }
            }
        }
    }

    public DataResolver getResolver() {
        return DataResolver.get(this.getContext(), this);
    }

    public ORecordValue createRecordValues(ContentValues values) {
        ORecordValue recordValue = new ORecordValue();
        for (OFieldType column : this.getColumns()) {
            if (!values.containsKey(column.getFieldName())) continue;
            Object value = values.get(column.getFieldName());
            if (column instanceof OManyToOne) {
                if (value instanceof byte[]) {
                    try {
                        ORecordValue m2oValue = (ORecordValue)ObjectByteUtils.byteToObject((byte[])value);
                        recordValue.put(column.getFieldName(), m2oValue);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                recordValue.put(column.getFieldName(), value);
                continue;
            }
            if (column instanceof OOneToMany || column instanceof OManyToMany) {
                try {
                    RelationValue relationValue = (RelationValue)ObjectByteUtils.byteToObject((byte[])value);
                    recordValue.put(column.getFieldName(), relationValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            recordValue.put(column.getFieldName(), values.get(column.getFieldName()));
        }
        return recordValue;
    }

    public String toString() {
        return "Model(" + this.getModelName() + ")";
    }
}

