/*
 * Decompiled with CFR 0.152.
 */
package com.oogbox.support.orm.core.types.helper;

import com.oogbox.support.orm.BaseModel;
import com.oogbox.support.orm.core.annotation.DataModel;
import java.util.HashMap;

public abstract class OFieldType<T> {
    private String fieldLabel = "Unknown";
    private String fieldName = "unknown";
    private int fieldSize = -1;
    private Boolean primaryKey = false;
    private Boolean autoIncrement = false;
    private Boolean isRequired = false;
    private Object defValue = null;
    private HashMap<String, String> enumMap = new HashMap();
    private Class<? extends BaseModel> refModel;
    private String refColumn;
    private Object value = null;

    public OFieldType(String label) {
        this.fieldLabel = label;
    }

    public abstract String fieldTypeString();

    public T setRefModel(Class<? extends BaseModel> refModel) {
        this.refModel = refModel;
        return (T)this;
    }

    public T setRefColumn(String refColumn) {
        this.refColumn = refColumn;
        return (T)this;
    }

    public T setName(String name) {
        this.fieldName = name;
        return (T)this;
    }

    public T setLabel(String label) {
        this.fieldLabel = label;
        return (T)this;
    }

    public T setSize(int size) {
        this.fieldSize = size;
        return (T)this;
    }

    public T primaryKey() {
        this.primaryKey = true;
        return (T)this;
    }

    public T autoIncrement() {
        this.autoIncrement = true;
        return (T)this;
    }

    public T setDefault(Object defValue) {
        this.defValue = defValue;
        return (T)this;
    }

    public T addEnum(String key, String value) {
        this.enumMap.put(key, value);
        return (T)this;
    }

    public T setRequired() {
        this.isRequired = true;
        return (T)this;
    }

    public T setValue(Object value) {
        this.value = value;
        return (T)this;
    }

    public String getLabel() {
        return this.fieldLabel;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getSize() {
        return this.fieldSize;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public Object getDefaultValue() {
        return this.defValue;
    }

    public Class<? extends BaseModel> getRefModel() {
        return this.refModel;
    }

    public String getRefColumn() {
        return this.refColumn;
    }

    public HashMap<String, String> getEnumMap() {
        return this.enumMap;
    }

    public String getEnumVal(String key) {
        if (this.enumMap.containsKey(key)) {
            return this.enumMap.get(key);
        }
        return null;
    }

    public String getRefModelTableName() {
        DataModel dataModel = this.getRefModel().getAnnotation(DataModel.class);
        if (dataModel != null) {
            return dataModel.value().replaceAll("\\.", "_");
        }
        return this.getRefModel().getName().toLowerCase();
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public Object getValue() {
        return this.value;
    }
}

