/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common.modeling;

import com.onesignal.common.events.EventProducer;
import com.onesignal.common.events.IEventNotifier;
import com.onesignal.common.modeling.IModelChangedHandler;
import com.onesignal.common.modeling.IModelStore;
import com.onesignal.common.modeling.IModelStoreChangeHandler;
import com.onesignal.common.modeling.Model;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.core.internal.preferences.IPreferencesService;
import com.onesignal.debug.internal.logging.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00020\u0006B\u001d\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u001bJ%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u001eJ)\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0017\u0010\"\u001a\u0004\u0018\u00018\u00002\u0006\u0010#\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016J\b\u0010'\u001a\u00020\u0018H\u0004J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0006\u0010+\u001a\u00020\u0018J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u001d\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010.\u001a\u00020\u00182\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000/2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0016\u00100\u001a\u00020\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016J\u0016\u00102\u001a\u00020\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00063"}, d2={"Lcom/onesignal/common/modeling/ModelStore;", "TModel", "Lcom/onesignal/common/modeling/Model;", "Lcom/onesignal/common/events/IEventNotifier;", "Lcom/onesignal/common/modeling/IModelStoreChangeHandler;", "Lcom/onesignal/common/modeling/IModelStore;", "Lcom/onesignal/common/modeling/IModelChangedHandler;", "name", "", "_prefs", "Lcom/onesignal/core/internal/preferences/IPreferencesService;", "(Ljava/lang/String;Lcom/onesignal/core/internal/preferences/IPreferencesService;)V", "changeSubscription", "Lcom/onesignal/common/events/EventProducer;", "hasLoadedFromCache", "", "hasSubscribers", "getHasSubscribers", "()Z", "models", "", "getName", "()Ljava/lang/String;", "add", "", "model", "tag", "(Lcom/onesignal/common/modeling/Model;Ljava/lang/String;)V", "index", "", "(ILcom/onesignal/common/modeling/Model;Ljava/lang/String;)V", "addItem", "(Lcom/onesignal/common/modeling/Model;Ljava/lang/String;Ljava/lang/Integer;)V", "clear", "get", "id", "(Ljava/lang/String;)Lcom/onesignal/common/modeling/Model;", "list", "", "load", "onChanged", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "persist", "remove", "removeItem", "replaceAll", "", "subscribe", "handler", "unsubscribe", "com.onesignal.core"})
@SourceDebugExtension(value={"SMAP\nModelStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelStore.kt\ncom/onesignal/common/modeling/ModelStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n288#2,2:230\n288#2,2:232\n288#2,2:235\n288#2,2:237\n1747#2,3:239\n1#3:234\n*S KotlinDebug\n*F\n+ 1 ModelStore.kt\ncom/onesignal/common/modeling/ModelStore\n*L\n46#1:230,2\n61#1:232,2\n78#1:235,2\n86#1:237,2\n184#1:239,3\n*E\n"})
public abstract class ModelStore<TModel extends Model>
implements IEventNotifier<IModelStoreChangeHandler<TModel>>,
IModelStore<TModel>,
IModelChangedHandler {
    @Nullable
    private final String name;
    @Nullable
    private final IPreferencesService _prefs;
    @NotNull
    private final EventProducer<IModelStoreChangeHandler<TModel>> changeSubscription;
    @NotNull
    private final List<TModel> models;
    private boolean hasLoadedFromCache;

    public ModelStore(@Nullable String name, @Nullable IPreferencesService _prefs) {
        this.name = name;
        this._prefs = _prefs;
        this.changeSubscription = new EventProducer();
        this.models = new ArrayList();
    }

    public /* synthetic */ ModelStore(String string, IPreferencesService iPreferencesService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            iPreferencesService = null;
        }
        this(string, iPreferencesService);
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<TModel> list = this.models;
        synchronized (list) {
            Object v0;
            block5: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.models;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Model it = (Model)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)((Model)model).getId())) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            Model oldModel = v0;
            if (oldModel != null) {
                this.removeItem(oldModel, tag);
            }
            ModelStore.addItem$default(this, model, tag, null, 4, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, @NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<TModel> list = this.models;
        synchronized (list) {
            Object v0;
            block5: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.models;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Model it = (Model)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)((Model)model).getId())) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            Model oldModel = v0;
            if (oldModel != null) {
                this.removeItem(oldModel, tag);
            }
            this.addItem(model, tag, index);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<TModel> list() {
        List list;
        List<TModel> list2 = this.models;
        synchronized (list2) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.models);
        }
        return list;
    }

    @Override
    @Nullable
    public TModel get(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable $this$firstOrNull$iv = this.models;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Model it = (Model)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (TModel)((Model)v0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NotNull String id, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<TModel> list = this.models;
        synchronized (list) {
            Object v0;
            block5: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.models;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Model it = (Model)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            Model model = v0;
            if (model == null) {
                return;
            }
            Model model2 = model;
            this.removeItem(model2, tag);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void onChanged(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.persist();
        this.changeSubscription.fire((Function1)new Function1<IModelStoreChangeHandler<TModel>, Unit>(args, tag){
            final /* synthetic */ ModelChangedArgs $args;
            final /* synthetic */ String $tag;
            {
                this.$args = $args;
                this.$tag = $tag;
                super(1);
            }

            public final void invoke(@NotNull IModelStoreChangeHandler<TModel> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.onModelUpdated(this.$args, this.$tag);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(@NotNull List<? extends TModel> models, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(models, (String)"models");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<TModel> list = models;
        synchronized (list) {
            boolean bl = false;
            this.clear(tag);
            for (Model model : models) {
                this.add(model, tag);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List localList = CollectionsKt.toList((Iterable)this.models);
        List<TModel> list = this.models;
        synchronized (list) {
            boolean bl = false;
            this.models.clear();
            this.persist();
            Unit unit = Unit.INSTANCE;
        }
        for (Model item : localList) {
            item.unsubscribe(this);
            this.changeSubscription.fire((Function1)new Function1<IModelStoreChangeHandler<TModel>, Unit>(item, tag){
                final /* synthetic */ TModel $item;
                final /* synthetic */ String $tag;
                {
                    this.$item = $item;
                    this.$tag = $tag;
                    super(1);
                }

                public final void invoke(@NotNull IModelStoreChangeHandler<TModel> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.onModelRemoved(this.$item, this.$tag);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addItem(TModel model, String tag, Integer index) {
        List<TModel> list = this.models;
        synchronized (list) {
            boolean bl = false;
            if (index != null) {
                this.models.add(index, model);
            } else {
                this.models.add(model);
            }
            ((Model)model).subscribe(this);
            this.persist();
            Unit unit = Unit.INSTANCE;
        }
        this.changeSubscription.fire((Function1)new Function1<IModelStoreChangeHandler<TModel>, Unit>(model, tag){
            final /* synthetic */ TModel $model;
            final /* synthetic */ String $tag;
            {
                this.$model = $model;
                this.$tag = $tag;
                super(1);
            }

            public final void invoke(@NotNull IModelStoreChangeHandler<TModel> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.onModelAdded(this.$model, this.$tag);
            }
        });
    }

    static /* synthetic */ void addItem$default(ModelStore modelStore, Model model, String string, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addItem");
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        modelStore.addItem(model, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeItem(TModel model, String tag) {
        List<TModel> list = this.models;
        synchronized (list) {
            boolean bl = false;
            this.models.remove(model);
            ((Model)model).unsubscribe(this);
            this.persist();
            Unit unit = Unit.INSTANCE;
        }
        this.changeSubscription.fire((Function1)new Function1<IModelStoreChangeHandler<TModel>, Unit>(model, tag){
            final /* synthetic */ TModel $model;
            final /* synthetic */ String $tag;
            {
                this.$model = $model;
                this.$tag = $tag;
                super(1);
            }

            public final void invoke(@NotNull IModelStoreChangeHandler<TModel> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.onModelRemoved(this.$model, this.$tag);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void load() {
        if (this.name == null || this._prefs == null) {
            return;
        }
        String str = this._prefs.getString("OneSignal", "MODEL_STORE_" + this.name, "[]");
        JSONArray jsonArray = new JSONArray(str);
        List<TModel> list = this.models;
        synchronized (list) {
            boolean bl = false;
            boolean shouldRePersist = !((Collection)this.models).isEmpty();
            for (int index = jsonArray.length() - 1; -1 < index; --index) {
                boolean hasExisting;
                Object newModel;
                block10: {
                    boolean bl2;
                    if (this.create(jsonArray.getJSONObject(index)) == null) continue;
                    Iterable $this$any$iv = this.models;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Model it = (Model)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)((Model)newModel).getId())) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = hasExisting = false;
                    }
                }
                if (hasExisting) {
                    Logging.debug$default("ModelStore<" + this.name + ">: load - operation.id: " + ((Model)newModel).getId() + " already exists in the store.", null, 2, null);
                    continue;
                }
                this.models.add(0, newModel);
                ((Model)newModel).subscribe(this);
            }
            this.hasLoadedFromCache = true;
            if (shouldRePersist) {
                this.persist();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persist() {
        if (this.name == null || this._prefs == null || !this.hasLoadedFromCache) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        List<TModel> list = this.models;
        synchronized (list) {
            boolean bl = false;
            for (Model model : this.models) {
                jsonArray.put((Object)model.toJSON());
            }
            Unit unit = Unit.INSTANCE;
        }
        this._prefs.saveString("OneSignal", "MODEL_STORE_" + this.name, jsonArray.toString());
    }

    @Override
    public void subscribe(@NotNull IModelStoreChangeHandler<TModel> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.changeSubscription.subscribe(handler);
    }

    @Override
    public void unsubscribe(@NotNull IModelStoreChangeHandler<TModel> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.changeSubscription.unsubscribe(handler);
    }

    @Override
    public boolean getHasSubscribers() {
        return this.changeSubscription.getHasSubscribers();
    }

    public ModelStore() {
        this(null, null, 3, null);
    }
}

