/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import com.onesignal.OSObservable;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalStateSynchronizer;
import org.json.JSONObject;

public class OSSMSSubscriptionState
implements Cloneable {
    private static final String CHANGED_KEY = "changed";
    private static final String SMS_USER_ID = "smsUserId";
    private static final String SMS_NUMBER = "smsNumber";
    private static final String SUBSCRIBED = "isSubscribed";
    private OSObservable<Object, OSSMSSubscriptionState> observable = new OSObservable("changed", false);
    private String smsUserId;
    private String smsNumber;

    OSSMSSubscriptionState(boolean asFrom) {
        if (asFrom) {
            this.smsUserId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_SMS_ID_LAST", null);
            this.smsNumber = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_SMS_NUMBER_LAST", null);
        } else {
            this.smsUserId = OneSignal.getSMSId();
            this.smsNumber = OneSignalStateSynchronizer.getSMSStateSynchronizer().getRegistrationId();
        }
    }

    void clearSMSAndId() {
        boolean changed = this.smsUserId != null || this.smsNumber != null;
        this.smsUserId = null;
        this.smsNumber = null;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    public String getSmsUserId() {
        return this.smsUserId;
    }

    void setSMSUserId(@NonNull String id2) {
        boolean changed = false;
        if (id2 == null) {
            changed = this.smsUserId != null;
        } else if (!id2.equals(this.smsUserId)) {
            changed = true;
        }
        this.smsUserId = id2;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    public String getSMSNumber() {
        return this.smsNumber;
    }

    void setSMSNumber(@NonNull String number) {
        boolean changed = !number.equals(this.smsNumber);
        this.smsNumber = number;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    public boolean isSubscribed() {
        return this.smsUserId != null && this.smsNumber != null;
    }

    void persistAsFrom() {
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_SMS_ID_LAST", this.smsUserId);
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_SMS_NUMBER_LAST", this.smsNumber);
    }

    boolean compare(OSSMSSubscriptionState from) {
        return !(this.smsUserId != null ? this.smsUserId : "").equals(from.smsUserId != null ? from.smsUserId : "") || !(this.smsNumber != null ? this.smsNumber : "").equals(from.smsNumber != null ? from.smsNumber : "");
    }

    public OSObservable<Object, OSSMSSubscriptionState> getObservable() {
        return this.observable;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            if (this.smsUserId != null) {
                mainObj.put(SMS_USER_ID, (Object)this.smsUserId);
            } else {
                mainObj.put(SMS_USER_ID, JSONObject.NULL);
            }
            if (this.smsNumber != null) {
                mainObj.put(SMS_NUMBER, (Object)this.smsNumber);
            } else {
                mainObj.put(SMS_NUMBER, JSONObject.NULL);
            }
            mainObj.put(SUBSCRIBED, this.isSubscribed());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return mainObj;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }
}

