/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import com.onesignal.AlertDialogPrepromptForAndroidSettings;
import com.onesignal.NavigateToAndroidSettingsForNotifications;
import com.onesignal.OneSignal;
import com.onesignal.PermissionsActivity;
import com.onesignal.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\b\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/onesignal/NotificationPermissionController;", "Lcom/onesignal/PermissionsActivity$PermissionCallback;", "()V", "ANDROID_PERMISSION_STRING", "", "PERMISSION_TYPE", "onAccept", "", "onReject", "fallbackToSettings", "", "prompt", "showFallbackAlertDialog", "onesignal_release"})
public final class NotificationPermissionController
implements PermissionsActivity.PermissionCallback {
    private static final String PERMISSION_TYPE = "NOTIFICATION";
    private static final String ANDROID_PERMISSION_STRING = "android.permission.POST_NOTIFICATIONS";
    @NotNull
    public static final NotificationPermissionController INSTANCE;

    public final void prompt(boolean fallbackToSettings) {
        if (Build.VERSION.SDK_INT < 32) {
            return;
        }
        PermissionsActivity.startPrompt(fallbackToSettings, PERMISSION_TYPE, ANDROID_PERMISSION_STRING, this.getClass());
    }

    @Override
    public void onAccept() {
        OneSignal.refreshNotificationPermissionState();
    }

    @Override
    public void onReject(boolean fallbackToSettings) {
        if (fallbackToSettings) {
            this.showFallbackAlertDialog();
        }
    }

    private final void showFallbackAlertDialog() {
        Activity activity = OneSignal.getCurrentActivity();
        if (activity == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"OneSignal.getCurrentActivity() ?: return");
        Activity activity2 = activity;
        String string2 = activity2.getString(R.string.notification_permission_name_for_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.str\u2026ermission_name_for_title)");
        String string3 = activity2.getString(R.string.notification_permission_settings_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.getString(R.str\u2026mission_settings_message)");
        AlertDialogPrepromptForAndroidSettings.INSTANCE.show(activity2, string2, string3, new AlertDialogPrepromptForAndroidSettings.Callback(activity2){
            final /* synthetic */ Activity $activity;

            public void onAccept() {
                NavigateToAndroidSettingsForNotifications.INSTANCE.show((Context)this.$activity);
            }

            public void onDecline() {
            }
            {
                this.$activity = $captured_local_variable$0;
            }
        });
    }

    private NotificationPermissionController() {
    }

    static {
        NotificationPermissionController notificationPermissionController;
        INSTANCE = notificationPermissionController = new NotificationPermissionController();
        PermissionsActivity.registerAsCallback(PERMISSION_TYPE, notificationPermissionController);
    }
}

