/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.AdvertisingIdProviderGPS;
import com.onesignal.AdvertisingIdentifierProvider;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.DelayedConsentInitializationParameters;
import com.onesignal.FocusTimeController;
import com.onesignal.JSONUtils;
import com.onesignal.LocationController;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationChannelManager;
import com.onesignal.NotificationSummaryManager;
import com.onesignal.OSDeviceState;
import com.onesignal.OSEmailSubscriptionChangedInternalObserver;
import com.onesignal.OSEmailSubscriptionObserver;
import com.onesignal.OSEmailSubscriptionState;
import com.onesignal.OSEmailSubscriptionStateChanges;
import com.onesignal.OSInAppMessageAction;
import com.onesignal.OSInAppMessageController;
import com.onesignal.OSInAppMessageControllerFactory;
import com.onesignal.OSInAppMessageOutcome;
import com.onesignal.OSLogWrapper;
import com.onesignal.OSLogger;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationAction;
import com.onesignal.OSNotificationController;
import com.onesignal.OSNotificationFormatHelper;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OSNotificationOpenedResult;
import com.onesignal.OSNotificationReceivedEvent;
import com.onesignal.OSNotificationRestoreWorkManager;
import com.onesignal.OSObservable;
import com.onesignal.OSOutcomeEventsController;
import com.onesignal.OSPermissionChangedInternalObserver;
import com.onesignal.OSPermissionObserver;
import com.onesignal.OSPermissionState;
import com.onesignal.OSPermissionStateChanges;
import com.onesignal.OSRemoteParamController;
import com.onesignal.OSSessionManager;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OSSharedPreferencesWrapper;
import com.onesignal.OSSubscriptionChangedInternalObserver;
import com.onesignal.OSSubscriptionObserver;
import com.onesignal.OSSubscriptionState;
import com.onesignal.OSSubscriptionStateChanges;
import com.onesignal.OSTaskController;
import com.onesignal.OSTime;
import com.onesignal.OSTimeImpl;
import com.onesignal.OSUtils;
import com.onesignal.OneSignalAPIClient;
import com.onesignal.OneSignalCacheCleaner;
import com.onesignal.OneSignalChromeTabAndroidFrame;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRemoteParams;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalRestClientWrapper;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.OneSignalSyncServiceUtils;
import com.onesignal.OutcomeEvent;
import com.onesignal.PushRegistrator;
import com.onesignal.PushRegistratorADM;
import com.onesignal.PushRegistratorFCM;
import com.onesignal.PushRegistratorHMS;
import com.onesignal.RootToolsInternalMethods;
import com.onesignal.TrackAmazonPurchase;
import com.onesignal.TrackFirebaseAnalytics;
import com.onesignal.TrackGooglePurchase;
import com.onesignal.UserStateSynchronizer;
import com.onesignal.influence.data.OSTrackerFactory;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.outcomes.data.OSOutcomeEventsFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneSignal {
    static final long MIN_ON_SESSION_TIME_MILLIS = 30000L;
    private static EmailUpdateHandler emailUpdateHandler;
    private static EmailUpdateHandler emailLogoutHandler;
    static Context appContext;
    static WeakReference<Activity> appActivity;
    static String appId;
    static String googleProjectNumber;
    private static LOG_LEVEL visualLogLevel;
    private static LOG_LEVEL logCatLevel;
    private static String userId;
    private static String emailId;
    private static int subscribableStatus;
    static OSRemoteNotificationReceivedHandler remoteNotificationReceivedHandler;
    static OSNotificationWillShowInForegroundHandler notificationWillShowInForegroundHandler;
    static OSNotificationOpenedHandler notificationOpenedHandler;
    static OSInAppMessageClickHandler inAppMessageClickHandler;
    static boolean mAutoPromptLocation;
    private static boolean initDone;
    private static boolean inForeground;
    @NonNull
    private static AppEntryAction appEntryState;
    private static TrackGooglePurchase trackGooglePurchase;
    private static TrackAmazonPurchase trackAmazonPurchase;
    private static TrackFirebaseAnalytics trackFirebaseAnalytics;
    public static final String VERSION = "040000";
    private static OSSessionManager.SessionListener sessionListener;
    private static OSInAppMessageControllerFactory inAppMessageControllerFactory;
    private static OSTime time;
    private static OSLogger logger;
    private static OSRemoteParamController remoteParamController;
    private static OSTaskController taskController;
    private static OneSignalAPIClient apiClient;
    private static OSSharedPreferences preferences;
    private static OSTrackerFactory trackerFactory;
    private static OSSessionManager sessionManager;
    @Nullable
    private static OSOutcomeEventsController outcomeEventsController;
    @Nullable
    private static OSOutcomeEventsFactory outcomeEventsFactory;
    @Nullable
    private static AdvertisingIdentifierProvider adIdProvider;
    public static String sdkType;
    private static String lastRegistrationId;
    @NonNull
    private static OSUtils osUtils;
    private static boolean registerForPushFired;
    private static boolean locationFired;
    private static boolean promptedLocation;
    private static boolean getTagsCall;
    private static boolean waitingToPostStateSync;
    private static LocationController.LocationPoint lastLocationPoint;
    private static Collection<JSONArray> unprocessedOpenedNotifs;
    private static HashSet<String> postedOpenedNotifIds;
    private static final ArrayList<OSGetTagsHandler> pendingGetTagsHandlers;
    static DelayedConsentInitializationParameters delayedInitParams;
    private static OSPermissionState currentPermissionState;
    static OSPermissionState lastPermissionState;
    private static OSObservable<OSPermissionObserver, OSPermissionStateChanges> permissionStateChangesObserver;
    private static OSSubscriptionState currentSubscriptionState;
    static OSSubscriptionState lastSubscriptionState;
    private static OSObservable<OSSubscriptionObserver, OSSubscriptionStateChanges> subscriptionStateChangesObserver;
    private static OSEmailSubscriptionState currentEmailSubscriptionState;
    static OSEmailSubscriptionState lastEmailSubscriptionState;
    private static OSObservable<OSEmailSubscriptionObserver, OSEmailSubscriptionStateChanges> emailSubscriptionStateChangesObserver;
    private static IAPUpdateJob iapUpdateJob;
    private static PushRegistrator mPushRegistrator;

    @Nullable
    static Activity getCurrentActivity() {
        ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
        return activityLifecycleHandler != null ? activityLifecycleHandler.getCurActivity() : null;
    }

    static boolean isInitDone() {
        return initDone;
    }

    static boolean isInForeground() {
        return inForeground;
    }

    @NonNull
    static AppEntryAction getAppEntryState() {
        return appEntryState;
    }

    static OSInAppMessageController getInAppMessageController() {
        return inAppMessageControllerFactory.getController(OneSignal.getDBHelperInstance(), OneSignal.getLogger());
    }

    @Nullable
    private static synchronized AdvertisingIdentifierProvider getAdIdProvider() {
        if (adIdProvider == null && OSUtils.isAndroidDeviceType()) {
            adIdProvider = new AdvertisingIdProviderGPS();
        }
        return adIdProvider;
    }

    private static OSPermissionState getCurrentPermissionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentPermissionState == null) {
            currentPermissionState = new OSPermissionState(false);
            OneSignal.currentPermissionState.observable.addObserverStrong(new OSPermissionChangedInternalObserver());
        }
        return currentPermissionState;
    }

    private static OSPermissionState getLastPermissionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastPermissionState == null) {
            lastPermissionState = new OSPermissionState(true);
        }
        return lastPermissionState;
    }

    static OSObservable<OSPermissionObserver, OSPermissionStateChanges> getPermissionStateChangesObserver() {
        if (permissionStateChangesObserver == null) {
            permissionStateChangesObserver = new OSObservable("onOSPermissionChanged", true);
        }
        return permissionStateChangesObserver;
    }

    private static OSSubscriptionState getCurrentSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentSubscriptionState == null) {
            currentSubscriptionState = new OSSubscriptionState(false, OneSignal.getCurrentPermissionState(context).areNotificationsEnabled());
            OneSignal.getCurrentPermissionState((Context)context).observable.addObserver(currentSubscriptionState);
            OneSignal.currentSubscriptionState.observable.addObserverStrong(new OSSubscriptionChangedInternalObserver());
        }
        return currentSubscriptionState;
    }

    private static OSSubscriptionState getLastSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastSubscriptionState == null) {
            lastSubscriptionState = new OSSubscriptionState(true, false);
        }
        return lastSubscriptionState;
    }

    static OSObservable<OSSubscriptionObserver, OSSubscriptionStateChanges> getSubscriptionStateChangesObserver() {
        if (subscriptionStateChangesObserver == null) {
            subscriptionStateChangesObserver = new OSObservable("onOSSubscriptionChanged", true);
        }
        return subscriptionStateChangesObserver;
    }

    private static OSEmailSubscriptionState getCurrentEmailSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentEmailSubscriptionState == null) {
            currentEmailSubscriptionState = new OSEmailSubscriptionState(false);
            OneSignal.currentEmailSubscriptionState.observable.addObserverStrong(new OSEmailSubscriptionChangedInternalObserver());
        }
        return currentEmailSubscriptionState;
    }

    static OSEmailSubscriptionState getEmailSubscriptionState() {
        return OneSignal.getCurrentEmailSubscriptionState(appContext);
    }

    private static OSEmailSubscriptionState getLastEmailSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastEmailSubscriptionState == null) {
            lastEmailSubscriptionState = new OSEmailSubscriptionState(true);
        }
        return lastEmailSubscriptionState;
    }

    static OSObservable<OSEmailSubscriptionObserver, OSEmailSubscriptionStateChanges> getEmailSubscriptionStateChangesObserver() {
        if (emailSubscriptionStateChangesObserver == null) {
            emailSubscriptionStateChangesObserver = new OSObservable("onOSEmailSubscriptionChanged", true);
        }
        return emailSubscriptionStateChangesObserver;
    }

    @Nullable
    public static OSDeviceState getDeviceState() {
        if (appContext == null) {
            logger.error("OneSignal.initWithContext has not been called. Could not get OSDeviceState");
            return null;
        }
        OSSubscriptionState subscriptionStatus = OneSignal.getCurrentSubscriptionState(appContext);
        OSPermissionState permissionStatus = OneSignal.getCurrentPermissionState(appContext);
        OSEmailSubscriptionState emailSubscriptionStatus = OneSignal.getCurrentEmailSubscriptionState(appContext);
        return new OSDeviceState(subscriptionStatus, permissionStatus, emailSubscriptionStatus);
    }

    public static void autoPromptLocation(boolean enable) {
        mAutoPromptLocation = enable;
    }

    public static void unsubscribeWhenNotificationsAreDisabled(final boolean set) {
        if (taskController.shouldQueueTaskForInit("unsubscribeWhenNotificationsAreDisabled()")) {
            logger.error("Waiting for remote params. Moving unsubscribeWhenNotificationsAreDisabled() operation to a pending task queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running unsubscribeWhenNotificationsAreDisabled() operation from pending task queue.");
                    OneSignal.unsubscribeWhenNotificationsAreDisabled(set);
                }
            });
            return;
        }
        if (OneSignal.getRemoteParamController().hasUnsubscribeNotificationKey()) {
            logger.warning("unsubscribeWhenNotificationsAreDisabled already called by remote params!, ignoring user set");
            return;
        }
        OneSignal.getRemoteParamController().saveUnsubscribeWhenNotificationsAreDisabled(set);
    }

    public static void setAppId(@NonNull String newAppId) {
        if (newAppId == null || newAppId.isEmpty()) {
            logger.warning("setAppId called with id: " + newAppId + ", ignoring!");
            return;
        }
        if (!newAppId.equals(appId)) {
            initDone = false;
            logger.verbose("setAppId called with id: " + newAppId + " changing id from: " + appId);
        }
        appId = newAppId;
        if (appContext == null) {
            logger.warning("appId set, but please call initWithContext(appContext) with Application context to complete OneSignal init!");
            return;
        }
        if (appActivity != null && appActivity.get() != null) {
            OneSignal.init((Context)appActivity.get());
        } else {
            OneSignal.init(appContext);
        }
    }

    public static void initWithContext(@NonNull Context context) {
        if (context == null) {
            logger.warning("initWithContext called with null context, ignoring!");
            return;
        }
        boolean wasAppContextNull = appContext == null;
        appContext = context.getApplicationContext();
        if (context instanceof Activity) {
            appActivity = new WeakReference<Activity>((Activity)context);
        }
        OneSignal.setupActivityLifecycleListener(wasAppContextNull);
        OneSignal.setupPrivacyConsent(appContext);
        if (appId == null) {
            String oldAppId = OneSignal.getSavedAppId();
            if (oldAppId == null) {
                logger.warning("appContext set, but please call setAppId(appId) with a valid appId to complete OneSignal init!");
            } else {
                logger.verbose("appContext set and cached app id found, calling setAppId with: " + oldAppId);
                OneSignal.setAppId(oldAppId);
            }
            return;
        }
        logger.verbose("initWithContext called with: " + context);
        OneSignal.init(context);
    }

    static void setRemoteNotificationReceivedHandler(OSRemoteNotificationReceivedHandler callback) {
        if (remoteNotificationReceivedHandler == null) {
            remoteNotificationReceivedHandler = callback;
        }
    }

    public static void setNotificationWillShowInForegroundHandler(@Nullable OSNotificationWillShowInForegroundHandler callback) {
        notificationWillShowInForegroundHandler = callback;
    }

    public static void setNotificationOpenedHandler(@Nullable OSNotificationOpenedHandler callback) {
        notificationOpenedHandler = callback;
        if (initDone && notificationOpenedHandler != null) {
            OneSignal.fireCallbackForOpenedNotifications();
        }
    }

    public static void setInAppMessageClickHandler(@Nullable OSInAppMessageClickHandler callback) {
        inAppMessageClickHandler = callback;
    }

    private static synchronized void init(Context context) {
        logger.verbose("Starting OneSignal initialization!");
        OSNotificationController.setupNotificationServiceExtension(appContext);
        if (OneSignal.requiresUserPrivacyConsent() || !remoteParamController.isRemoteParamsCallDone()) {
            if (!remoteParamController.isRemoteParamsCallDone()) {
                logger.verbose("OneSignal SDK initialization delayed, waiting for remote params.");
            } else {
                logger.verbose("OneSignal SDK initialization delayed, waiting for privacy consent to be set.");
            }
            delayedInitParams = new DelayedConsentInitializationParameters(context, appId);
            String lastAppId = appId;
            appId = null;
            if (lastAppId != null && context != null) {
                OneSignal.makeAndroidParamsRequest(lastAppId, OneSignal.getUserId());
            }
            return;
        }
        int n = subscribableStatus = subscribableStatus != Integer.MAX_VALUE ? subscribableStatus : osUtils.initializationChecker(appContext, appId);
        if (OneSignal.isSubscriptionStatusUninitializable()) {
            return;
        }
        if (initDone) {
            if (notificationOpenedHandler != null) {
                OneSignal.fireCallbackForOpenedNotifications();
            }
            logger.debug("OneSignal SDK initialization already completed.");
            return;
        }
        OneSignal.handleActivityLifecycleHandler(context);
        appActivity = null;
        OneSignalStateSynchronizer.initUserState();
        OneSignal.handleAppIdChange();
        OneSignal.handleAmazonPurchase();
        OSPermissionChangedInternalObserver.handleInternalChanges(OneSignal.getCurrentPermissionState(appContext));
        OneSignal.doSessionInit();
        if (notificationOpenedHandler != null) {
            OneSignal.fireCallbackForOpenedNotifications();
        }
        if (TrackGooglePurchase.CanTrack(appContext)) {
            trackGooglePurchase = new TrackGooglePurchase(appContext);
        }
        if (TrackFirebaseAnalytics.CanTrack()) {
            trackFirebaseAnalytics = new TrackFirebaseAnalytics(appContext);
        }
        initDone = true;
        OneSignal.Log(LOG_LEVEL.VERBOSE, "OneSignal SDK initialization done.");
        outcomeEventsController.sendSavedOutcomes();
        taskController.startPendingTasks();
    }

    static void onRemoteParamSet() {
        if (delayedInitParams != null) {
            OneSignal.reassignDelayedInitParams();
        } else if (inForeground) {
            OneSignal.onAppFocusLogic();
        }
    }

    private static void setupActivityLifecycleListener(boolean wasAppContextNull) {
        ActivityLifecycleListener.registerActivityLifecycleCallbacks((Application)appContext);
        if (wasAppContextNull) {
            if (outcomeEventsFactory == null) {
                outcomeEventsFactory = new OSOutcomeEventsFactory(logger, apiClient, OneSignal.getDBHelperInstance(), preferences);
            }
            sessionManager.initSessionFromCache();
            outcomeEventsController = new OSOutcomeEventsController(sessionManager, outcomeEventsFactory);
            OneSignalPrefs.startDelayedWrite();
            OneSignalCacheCleaner.cleanOldCachedData(appContext);
        }
    }

    private static void setupPrivacyConsent(Context context) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String requireSetting = bundle.getString("com.onesignal.PrivacyConsent");
            OneSignal.setRequiresUserPrivacyConsent("ENABLE".equalsIgnoreCase(requireSetting));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void handleAppIdChange() {
        String oldAppId = OneSignal.getSavedAppId();
        if (oldAppId != null) {
            if (!oldAppId.equals(appId)) {
                OneSignal.Log(LOG_LEVEL.DEBUG, "App id has changed:\nFrom: " + oldAppId + "\n To: " + appId + "\nClearing the user id, app state, and remoteParams as they are no longer valid");
                OneSignal.saveAppId(appId);
                OneSignalStateSynchronizer.resetCurrentState();
                remoteParamController.clearRemoteParams();
            }
        } else {
            OneSignal.Log(LOG_LEVEL.DEBUG, "App id set for first time:  " + appId);
            BadgeCountUpdater.updateCount(0, appContext);
            OneSignal.saveAppId(appId);
        }
    }

    public static boolean userProvidedPrivacyConsent() {
        return remoteParamController.getSavedUserConsentStatus();
    }

    private static boolean isSubscriptionStatusUninitializable() {
        return subscribableStatus == -999;
    }

    private static void handleActivityLifecycleHandler(Context context) {
        ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
        inForeground = OneSignal.getCurrentActivity() != null || context instanceof Activity;
        logger.debug("OneSignal handleActivityLifecycleHandler inForeground: " + inForeground);
        if (inForeground) {
            if (OneSignal.getCurrentActivity() == null && activityLifecycleHandler != null) {
                activityLifecycleHandler.setCurActivity((Activity)context);
                activityLifecycleHandler.setNextResumeIsFirstActivity(true);
            }
            OSNotificationRestoreWorkManager.beginEnqueueingWork(context, false);
            FocusTimeController.getInstance().appForegrounded();
        } else if (activityLifecycleHandler != null) {
            activityLifecycleHandler.setNextResumeIsFirstActivity(true);
        }
    }

    private static void handleAmazonPurchase() {
        try {
            Class.forName("com.amazon.device.iap.PurchasingListener");
            trackAmazonPurchase = new TrackAmazonPurchase(appContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void doSessionInit() {
        if (OneSignal.isPastOnSessionTime()) {
            OneSignal.onesignalLog(LOG_LEVEL.DEBUG, "Starting new session");
            OneSignalStateSynchronizer.setNewSession();
            if (inForeground) {
                outcomeEventsController.cleanOutcomes();
                sessionManager.restartSessionIfNeeded(OneSignal.getAppEntryState());
                OneSignal.getInAppMessageController().resetSessionLaunchTime();
            }
        } else if (inForeground) {
            OneSignal.onesignalLog(LOG_LEVEL.DEBUG, "Continue on same session");
            sessionManager.attemptSessionUpgrade(OneSignal.getAppEntryState());
        }
        OneSignal.getInAppMessageController().initWithCachedInAppMessages();
        if (!inForeground && OneSignal.hasUserId()) {
            return;
        }
        OneSignal.setLastSessionTime(time.getCurrentTimeMillis());
        OneSignal.startRegistrationOrOnSession();
    }

    private static void startRegistrationOrOnSession() {
        if (waitingToPostStateSync) {
            return;
        }
        waitingToPostStateSync = true;
        if (OneSignalStateSynchronizer.getSyncAsNewSession()) {
            locationFired = false;
        }
        OneSignal.startLocationUpdate();
        registerForPushFired = false;
        if (OneSignal.getRemoteParams() != null) {
            OneSignal.registerForPushToken();
        } else {
            OneSignal.makeAndroidParamsRequest(appId, OneSignal.getUserId());
        }
    }

    private static void startLocationUpdate() {
        LocationController.LocationHandler locationHandler = new LocationController.LocationHandler(){

            @Override
            public LocationController.PermissionType getType() {
                return LocationController.PermissionType.STARTUP;
            }

            @Override
            public void onComplete(LocationController.LocationPoint point) {
                lastLocationPoint = point;
                locationFired = true;
                OneSignal.registerUser();
            }
        };
        boolean doPrompt = mAutoPromptLocation && !promptedLocation;
        promptedLocation = promptedLocation || mAutoPromptLocation;
        LocationController.getLocation(appContext, doPrompt, false, locationHandler);
    }

    private static PushRegistrator getPushRegistrator() {
        if (mPushRegistrator != null) {
            return mPushRegistrator;
        }
        if (OSUtils.isFireOSDeviceType()) {
            mPushRegistrator = new PushRegistratorADM();
        } else if (OSUtils.isAndroidDeviceType()) {
            if (OSUtils.hasFCMLibrary()) {
                mPushRegistrator = new PushRegistratorFCM();
            }
        } else {
            mPushRegistrator = new PushRegistratorHMS();
        }
        return mPushRegistrator;
    }

    private static void registerForPushToken() {
        OneSignal.getPushRegistrator().registerForPush(appContext, googleProjectNumber, new PushRegistrator.RegisteredHandler(){

            @Override
            public void complete(String id2, int status) {
                if (status < 1) {
                    if (OneSignalStateSynchronizer.getRegistrationId() == null && (subscribableStatus == 1 || OneSignal.pushStatusRuntimeError(subscribableStatus))) {
                        subscribableStatus = status;
                    }
                } else if (OneSignal.pushStatusRuntimeError(subscribableStatus)) {
                    subscribableStatus = status;
                }
                lastRegistrationId = id2;
                registerForPushFired = true;
                OneSignal.getCurrentSubscriptionState(appContext).setPushToken(id2);
                OneSignal.registerUser();
            }
        });
    }

    private static boolean pushStatusRuntimeError(int subscriptionStatus) {
        return subscriptionStatus < -6;
    }

    private static void makeAndroidParamsRequest(String appId, String userId) {
        if (OneSignal.getRemoteParams() != null) {
            return;
        }
        OneSignalRemoteParams.makeAndroidParamsRequest(appId, userId, new OneSignalRemoteParams.Callback(){

            @Override
            public void complete(OneSignalRemoteParams.Params params) {
                if (params.googleProjectNumber != null) {
                    googleProjectNumber = params.googleProjectNumber;
                }
                remoteParamController.saveRemoteParams(params, trackerFactory, preferences, logger);
                OneSignal.onRemoteParamSet();
                NotificationChannelManager.processChannelList(appContext, params.notificationChannels);
            }
        });
    }

    private static void fireCallbackForOpenedNotifications() {
        for (JSONArray dataArray : unprocessedOpenedNotifs) {
            OneSignal.runNotificationOpenedCallback(dataArray);
        }
        unprocessedOpenedNotifs.clear();
    }

    public static void onesignalLog(LOG_LEVEL level, String message) {
        OneSignal.Log(level, message);
    }

    public static void provideUserConsent(boolean consent) {
        boolean previousConsentStatus = OneSignal.userProvidedPrivacyConsent();
        remoteParamController.saveUserConsentStatus(consent);
        if (!previousConsentStatus && consent && delayedInitParams != null) {
            OneSignal.Log(LOG_LEVEL.VERBOSE, "Privacy consent provided, reassigning all delayed init params and attempting init again...");
            OneSignal.reassignDelayedInitParams();
        }
    }

    private static void reassignDelayedInitParams() {
        Context delayedContext = OneSignal.delayedInitParams.context;
        String delayedAppId = OneSignal.delayedInitParams.appId;
        delayedInitParams = null;
        OneSignal.setAppId(delayedAppId);
        OneSignal.initWithContext(delayedContext);
    }

    static OneSignalRemoteParams.Params getRemoteParams() {
        return remoteParamController.getRemoteParams();
    }

    public static boolean requiresUserPrivacyConsent() {
        return appContext == null || OneSignal.isUserPrivacyConsentRequired() && !OneSignal.userProvidedPrivacyConsent();
    }

    public static void setRequiresUserPrivacyConsent(boolean required) {
        if (OneSignal.getRemoteParamController().hasPrivacyConsentKey()) {
            logger.warning("setRequiresUserPrivacyConsent already called by remote params!, ignoring user set");
            return;
        }
        if (OneSignal.requiresUserPrivacyConsent() && !required) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Cannot change requiresUserPrivacyConsent() from TRUE to FALSE");
            return;
        }
        OneSignal.getRemoteParamController().savePrivacyConsentRequired(required);
    }

    static boolean shouldLogUserPrivacyConsentErrorMessageForMethodName(String methodName) {
        if (OneSignal.requiresUserPrivacyConsent()) {
            if (methodName != null) {
                OneSignal.Log(LOG_LEVEL.WARN, "Method " + methodName + " was called before the user provided privacy consent. Your application is set to require the user's privacy consent before the OneSignal SDK can be initialized. Please ensure the user has provided consent before calling this method. You can check the latest OneSignal consent status by calling OneSignal.userProvidedPrivacyConsent()");
            }
            return true;
        }
        return false;
    }

    public static void setLogLevel(LOG_LEVEL inLogCatLevel, LOG_LEVEL inVisualLogLevel) {
        logCatLevel = inLogCatLevel;
        visualLogLevel = inVisualLogLevel;
    }

    public static void setLogLevel(int inLogCatLevel, int inVisualLogLevel) {
        OneSignal.setLogLevel(OneSignal.getLogLevel(inLogCatLevel), OneSignal.getLogLevel(inVisualLogLevel));
    }

    private static LOG_LEVEL getLogLevel(int level) {
        switch (level) {
            case 0: {
                return LOG_LEVEL.NONE;
            }
            case 1: {
                return LOG_LEVEL.FATAL;
            }
            case 2: {
                return LOG_LEVEL.ERROR;
            }
            case 3: {
                return LOG_LEVEL.WARN;
            }
            case 4: {
                return LOG_LEVEL.INFO;
            }
            case 5: {
                return LOG_LEVEL.DEBUG;
            }
            case 6: {
                return LOG_LEVEL.VERBOSE;
            }
        }
        if (level < 0) {
            return LOG_LEVEL.NONE;
        }
        return LOG_LEVEL.VERBOSE;
    }

    static boolean atLogLevel(LOG_LEVEL level) {
        return level.compareTo(visualLogLevel) < 1 || level.compareTo(logCatLevel) < 1;
    }

    static void Log(@NonNull LOG_LEVEL level, @NonNull String message) {
        OneSignal.Log(level, message, null);
    }

    static void Log(final @NonNull LOG_LEVEL level, @NonNull String message, @Nullable Throwable throwable) {
        String TAG = "OneSignal";
        if (level.compareTo(logCatLevel) < 1) {
            if (level == LOG_LEVEL.VERBOSE) {
                Log.v((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.DEBUG) {
                Log.d((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.INFO) {
                Log.i((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.WARN) {
                Log.w((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.ERROR || level == LOG_LEVEL.FATAL) {
                Log.e((String)"OneSignal", (String)message, (Throwable)throwable);
            }
        }
        if (level.compareTo(visualLogLevel) < 1 && OneSignal.getCurrentActivity() != null) {
            try {
                String fullMessage = message + "\n";
                if (throwable != null) {
                    fullMessage = fullMessage + throwable.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    fullMessage = fullMessage + sw.toString();
                }
                final String finalFullMessage = fullMessage;
                OSUtils.runOnMainUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (OneSignal.getCurrentActivity() != null) {
                            new AlertDialog.Builder((Context)OneSignal.getCurrentActivity()).setTitle((CharSequence)level.toString()).setMessage((CharSequence)finalFullMessage).show();
                        }
                    }
                });
            }
            catch (Throwable t) {
                Log.e((String)"OneSignal", (String)"Error showing logging message.", (Throwable)t);
            }
        }
    }

    static void logHttpError(String errorString, int statusCode, Throwable throwable, String errorResponse) {
        String jsonError = "";
        if (errorResponse != null && OneSignal.atLogLevel(LOG_LEVEL.INFO)) {
            jsonError = "\n" + errorResponse + "\n";
        }
        OneSignal.Log(LOG_LEVEL.WARN, "HTTP code: " + statusCode + " " + errorString + jsonError, throwable);
    }

    static OSLogger getLogger() {
        return logger;
    }

    @WorkerThread
    static void onAppLostFocus() {
        OneSignal.Log(LOG_LEVEL.DEBUG, "Application lost focus");
        inForeground = false;
        appEntryState = AppEntryAction.APP_CLOSE;
        OneSignal.setLastSessionTime(OneSignal.getTime().getCurrentTimeMillis());
        LocationController.onFocusChange();
        if (!initDone) {
            return;
        }
        if (trackAmazonPurchase != null) {
            trackAmazonPurchase.checkListener();
        }
        FocusTimeController.getInstance().appBackgrounded();
        OneSignal.scheduleSyncService();
    }

    private static boolean scheduleSyncService() {
        boolean locationScheduled;
        boolean unsyncedChanges = OneSignalStateSynchronizer.persist();
        if (unsyncedChanges) {
            OneSignalSyncServiceUtils.scheduleSyncTask(appContext);
        }
        return (locationScheduled = LocationController.scheduleUpdate(appContext)) || unsyncedChanges;
    }

    static void onAppFocus() {
        OneSignal.Log(LOG_LEVEL.DEBUG, "Application on focus");
        inForeground = true;
        if (!appEntryState.equals((Object)AppEntryAction.NOTIFICATION_CLICK)) {
            appEntryState = AppEntryAction.APP_OPEN;
        }
        LocationController.onFocusChange();
        if (OSUtils.shouldLogMissingAppIdError(appId)) {
            return;
        }
        if (!remoteParamController.isRemoteParamsCallDone()) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Delay onAppFocus logic due to missing remote params");
            OneSignal.makeAndroidParamsRequest(appId, OneSignal.getUserId());
            return;
        }
        OneSignal.onAppFocusLogic();
    }

    private static void onAppFocusLogic() {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("onAppFocus")) {
            return;
        }
        FocusTimeController.getInstance().appForegrounded();
        OneSignal.doSessionInit();
        if (trackGooglePurchase != null) {
            trackGooglePurchase.trackIAP();
        }
        OSNotificationRestoreWorkManager.beginEnqueueingWork(appContext, false);
        OneSignal.getCurrentPermissionState(appContext).refreshAsTo();
        if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled()) {
            trackFirebaseAnalytics.trackInfluenceOpenEvent();
        }
        OneSignalSyncServiceUtils.cancelSyncTask(appContext);
    }

    static void addNetType(JSONObject jsonObj) {
        try {
            jsonObj.put("net_type", (Object)osUtils.getNetType());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getTimeZoneOffset() {
        TimeZone timezone = Calendar.getInstance().getTimeZone();
        int offset = timezone.getRawOffset();
        if (timezone.inDaylightTime(new Date())) {
            offset += timezone.getDSTSavings();
        }
        return offset / 1000;
    }

    private static void registerUser() {
        OneSignal.Log(LOG_LEVEL.DEBUG, "registerUser:registerForPushFired:" + registerForPushFired + ", locationFired: " + locationFired + ", remoteParams: " + OneSignal.getRemoteParams() + ", appId: " + appId);
        if (!registerForPushFired || !locationFired || OneSignal.getRemoteParams() == null || appId == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OneSignal.registerUserTask();
                    OneSignalChromeTabAndroidFrame.setup(appId, userId, AdvertisingIdProviderGPS.getLastValue(), OneSignal.getRemoteParams());
                }
                catch (JSONException t) {
                    OneSignal.Log(LOG_LEVEL.FATAL, "FATAL Error registering device!", t);
                }
            }
        }, "OS_REG_USER").start();
    }

    private static void registerUserTask() throws JSONException {
        String adId22;
        String packageName = appContext.getPackageName();
        PackageManager packageManager = appContext.getPackageManager();
        JSONObject deviceInfo = new JSONObject();
        deviceInfo.put("app_id", (Object)OneSignal.getSavedAppId());
        if (OneSignal.getAdIdProvider() != null && (adId22 = OneSignal.getAdIdProvider().getIdentifier(appContext)) != null) {
            deviceInfo.put("ad_id", (Object)adId22);
        }
        deviceInfo.put("device_os", (Object)Build.VERSION.RELEASE);
        deviceInfo.put("timezone", OneSignal.getTimeZoneOffset());
        deviceInfo.put("language", (Object)OSUtils.getCorrectedLanguage());
        deviceInfo.put("sdk", (Object)VERSION);
        deviceInfo.put("sdk_type", (Object)sdkType);
        deviceInfo.put("android_package", (Object)packageName);
        deviceInfo.put("device_model", (Object)Build.MODEL);
        try {
            deviceInfo.put("game_version", packageManager.getPackageInfo((String)packageName, (int)0).versionCode);
        }
        catch (PackageManager.NameNotFoundException adId22) {
            // empty catch block
        }
        deviceInfo.put("net_type", (Object)osUtils.getNetType());
        deviceInfo.put("carrier", (Object)osUtils.getCarrierName());
        deviceInfo.put("rooted", RootToolsInternalMethods.isRooted());
        OneSignalStateSynchronizer.updateDeviceInfo(deviceInfo);
        JSONObject pushState = new JSONObject();
        pushState.put("identifier", (Object)lastRegistrationId);
        pushState.put("subscribableStatus", subscribableStatus);
        pushState.put("androidPermission", OneSignal.areNotificationsEnabledForSubscribedState());
        pushState.put("device_type", osUtils.getDeviceType());
        OneSignalStateSynchronizer.updatePushState(pushState);
        if (OneSignal.isLocationShared() && lastLocationPoint != null) {
            OneSignalStateSynchronizer.updateLocation(lastLocationPoint);
        }
        OneSignalStateSynchronizer.readyToUpdate(true);
        waitingToPostStateSync = false;
    }

    public static void setEmail(@NonNull String email, EmailUpdateHandler callback) {
        OneSignal.setEmail(email, null, callback);
    }

    public static void setEmail(@NonNull String email) {
        OneSignal.setEmail(email, null, null);
    }

    public static void setEmail(@NonNull String email, @Nullable String emailAuthHash) {
        OneSignal.setEmail(email, emailAuthHash, null);
    }

    public static void setEmail(final @NonNull String email, final @Nullable String emailAuthHash, final @Nullable EmailUpdateHandler callback) {
        if (taskController.shouldQueueTaskForInit("setEmail()")) {
            logger.error("Waiting for remote params. Moving setEmail() operation to a pending task queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running setEmail() operation from a pending task queue.");
                    OneSignal.setEmail(email, emailAuthHash, callback);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setEmail()")) {
            return;
        }
        if (!OSUtils.isValidEmail(email)) {
            String errorMessage = "Email is invalid";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.VALIDATION, errorMessage));
            }
            logger.error(errorMessage);
            return;
        }
        if (OneSignal.getRemoteParams().useEmailAuth && emailAuthHash == null) {
            String errorMessage = "Email authentication (auth token) is set to REQUIRED for this application. Please provide an auth token from your backend server or change the setting in the OneSignal dashboard.";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.REQUIRES_EMAIL_AUTH, errorMessage));
            }
            logger.error(errorMessage);
            return;
        }
        emailUpdateHandler = callback;
        String trimmedEmail = email.trim();
        String internalEmailAuthHash = emailAuthHash;
        if (internalEmailAuthHash != null) {
            internalEmailAuthHash = internalEmailAuthHash.toLowerCase();
        }
        OneSignal.getCurrentEmailSubscriptionState(appContext).setEmailAddress(trimmedEmail);
        OneSignalStateSynchronizer.setEmail(trimmedEmail.toLowerCase(), internalEmailAuthHash);
    }

    public static void logoutEmail() {
        OneSignal.logoutEmail(null);
    }

    public static void logoutEmail(final @Nullable EmailUpdateHandler callback) {
        if (taskController.shouldQueueTaskForInit("logoutEmail()")) {
            logger.error("Waiting for remote params. Moving logoutEmail() operation to a pending task queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running  logoutEmail() operation from pending task queue.");
                    OneSignal.logoutEmail(callback);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("logoutEmail()")) {
            return;
        }
        if (OneSignal.getEmailId() == null) {
            String message = "logoutEmail not valid as email was not set or already logged out!";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.INVALID_OPERATION, "logoutEmail not valid as email was not set or already logged out!"));
            }
            logger.error("logoutEmail not valid as email was not set or already logged out!");
            return;
        }
        emailLogoutHandler = callback;
        OneSignalStateSynchronizer.logoutEmail();
    }

    public static void setExternalUserId(@NonNull String externalId) {
        OneSignal.setExternalUserId(externalId, null);
    }

    public static void setExternalUserId(final @NonNull String externalId, final @Nullable OSExternalUserIdUpdateCompletionHandler completionCallback) {
        if (taskController.shouldQueueTaskForInit("setExternalUserId()")) {
            logger.error("Waiting for remote params. Moving setExternalUserId() operation to a pending task queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running setExternalUserId() operation from pending task queue.");
                    OneSignal.setExternalUserId(externalId, completionCallback);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setExternalUserId()")) {
            return;
        }
        if (externalId == null) {
            logger.warning("External id can't be null, set an empty string to remove an external id");
            return;
        }
        try {
            OneSignalStateSynchronizer.setExternalUserId(externalId, completionCallback);
        }
        catch (JSONException exception) {
            String operation = externalId.equals("") ? "remove" : "set";
            logger.error("Attempted to " + operation + " external ID but encountered a JSON exception");
            exception.printStackTrace();
        }
    }

    public static void removeExternalUserId() {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("removeExternalUserId()")) {
            return;
        }
        OneSignal.removeExternalUserId(null);
    }

    public static void removeExternalUserId(OSExternalUserIdUpdateCompletionHandler completionHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("removeExternalUserId()")) {
            return;
        }
        OneSignal.setExternalUserId("", completionHandler);
    }

    public static void sendTag(final String key, final String value) {
        if (taskController.shouldQueueTaskForInit("sendTag()")) {
            logger.error("Waiting for remote params. Moving sendTag() operation to a pending task queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running sendTag() operation from pending task queue.");
                    OneSignal.sendTag(key, value);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendTag()")) {
            return;
        }
        try {
            OneSignal.sendTags(new JSONObject().put(key, (Object)value));
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    public static void sendTags(String jsonString) {
        try {
            OneSignal.sendTags(new JSONObject(jsonString));
        }
        catch (JSONException t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSONObject for sendTags failed!", t);
        }
    }

    public static void sendTags(JSONObject keyValues) {
        OneSignal.sendTags(keyValues, null);
    }

    public static void sendTags(final JSONObject keyValues, final ChangeTagsUpdateHandler changeTagsUpdateHandler) {
        if (taskController.shouldQueueTaskForInit("sendTags()")) {
            logger.error("Waiting for remote params. Moving sendTags() operation to a pending task queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running sendTags() operation from pending task queue.");
                    OneSignal.sendTags(keyValues, changeTagsUpdateHandler);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendTags()")) {
            return;
        }
        Runnable sendTagsRunnable = new Runnable(){

            @Override
            public void run() {
                if (keyValues == null) {
                    logger.error("Attempted to send null tags");
                    if (changeTagsUpdateHandler != null) {
                        changeTagsUpdateHandler.onFailure(new SendTagsError(-1, "Attempted to send null tags"));
                    }
                    return;
                }
                JSONObject existingKeys = OneSignalStateSynchronizer.getTags((boolean)false).result;
                JSONObject toSend = new JSONObject();
                Iterator keys = keyValues.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    try {
                        Object value = keyValues.opt(key);
                        if (value instanceof JSONArray || value instanceof JSONObject) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Omitting key '" + key + "'! sendTags DO NOT supported nested values!");
                            continue;
                        }
                        if (keyValues.isNull(key) || "".equals(value)) {
                            if (existingKeys == null || !existingKeys.has(key)) continue;
                            toSend.put(key, (Object)"");
                            continue;
                        }
                        toSend.put(key, (Object)value.toString());
                    }
                    catch (Throwable throwable) {}
                }
                if (!toSend.toString().equals("{}")) {
                    logger.debug("Available tags to send: " + toSend.toString());
                    OneSignalStateSynchronizer.sendTags(toSend, changeTagsUpdateHandler);
                } else {
                    logger.debug("Send tags ended successfully");
                    if (changeTagsUpdateHandler != null) {
                        changeTagsUpdateHandler.onSuccess(existingKeys);
                    }
                }
            }
        };
        if (taskController.shouldRunTaskThroughQueue()) {
            logger.debug("Sending sendTags() operation to pending task queue.");
            taskController.addTaskToQueue(sendTagsRunnable);
            return;
        }
        sendTagsRunnable.run();
    }

    public static void postNotification(String json, PostNotificationResponseHandler handler) {
        try {
            OneSignal.postNotification(new JSONObject(json), handler);
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Invalid postNotification JSON format: " + json);
        }
    }

    public static void postNotification(JSONObject json, final PostNotificationResponseHandler handler) {
        block8: {
            if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("postNotification()")) {
                return;
            }
            try {
                if (!json.has("app_id")) {
                    json.put("app_id", (Object)OneSignal.getSavedAppId());
                }
                if (!json.has("app_id")) {
                    if (handler != null) {
                        handler.onFailure(new JSONObject().put("error", (Object)"Missing app_id"));
                    }
                    return;
                }
                OneSignalRestClient.post("notifications/", json, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    public void onSuccess(String response) {
                        logger.debug("HTTP create notification success: " + (response != null ? response : "null"));
                        if (handler != null) {
                            try {
                                JSONObject jsonObject = new JSONObject(response);
                                if (jsonObject.has("errors")) {
                                    handler.onFailure(jsonObject);
                                } else {
                                    handler.onSuccess(new JSONObject(response));
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("create notification failed", statusCode, throwable, response);
                        if (handler != null) {
                            try {
                                if (statusCode == 0) {
                                    response = "{\"error\": \"HTTP no response error\"}";
                                }
                                handler.onFailure(new JSONObject(response));
                            }
                            catch (Throwable t) {
                                try {
                                    handler.onFailure(new JSONObject("{\"error\": \"Unknown response!\"}"));
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
            catch (JSONException e) {
                logger.error("HTTP create notification json exception!", e);
                if (handler == null) break block8;
                try {
                    handler.onFailure(new JSONObject("{'error': 'HTTP create notification json exception!'}"));
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void getTags(final OSGetTagsHandler getTagsHandler) {
        if (taskController.shouldQueueTaskForInit("getTags()")) {
            logger.error("Waiting for remote params. Moving getTags() operation to a pending queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running getTags() operation from pending queue.");
                    OneSignal.getTags(getTagsHandler);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("getTags()")) {
            return;
        }
        if (getTagsHandler == null) {
            logger.error("getTags called with null GetTagsHandler!");
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList arrayList = pendingGetTagsHandlers;
                synchronized (arrayList) {
                    pendingGetTagsHandlers.add(getTagsHandler);
                    if (pendingGetTagsHandlers.size() > 1) {
                        return;
                    }
                }
                OneSignal.runGetTags();
            }
        }, "OS_GETTAGS").start();
    }

    private static void runGetTags() {
        if (OneSignal.getUserId() == null) {
            return;
        }
        OneSignal.internalFireGetTagsCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalFireGetTagsCallbacks() {
        ArrayList<OSGetTagsHandler> arrayList = pendingGetTagsHandlers;
        synchronized (arrayList) {
            if (pendingGetTagsHandlers.size() == 0) {
                return;
            }
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UserStateSynchronizer.GetTagsResult tags = OneSignalStateSynchronizer.getTags(!getTagsCall);
                if (tags.serverSuccess) {
                    getTagsCall = true;
                }
                ArrayList arrayList = pendingGetTagsHandlers;
                synchronized (arrayList) {
                    for (OSGetTagsHandler handler : pendingGetTagsHandlers) {
                        handler.tagsAvailable(tags.result == null || tags.toString().equals("{}") ? null : tags.result);
                    }
                    pendingGetTagsHandlers.clear();
                }
            }
        }, "OS_GETTAGS_CALLBACK").start();
    }

    public static void deleteTag(String key) {
        OneSignal.deleteTag(key, null);
    }

    public static void deleteTag(String key, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTag()")) {
            return;
        }
        ArrayList<String> tempList = new ArrayList<String>(1);
        tempList.add(key);
        OneSignal.deleteTags(tempList, handler);
    }

    public static void deleteTags(Collection<String> keys) {
        OneSignal.deleteTags(keys, null);
    }

    public static void deleteTags(Collection<String> keys, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTags()")) {
            return;
        }
        try {
            JSONObject jsonTags = new JSONObject();
            for (String key : keys) {
                jsonTags.put(key, (Object)"");
            }
            OneSignal.sendTags(jsonTags, handler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(String jsonArrayString) {
        OneSignal.deleteTags(jsonArrayString, null);
    }

    public static void deleteTags(String jsonArrayString, ChangeTagsUpdateHandler handler) {
        try {
            OneSignal.deleteTags(new JSONArray(jsonArrayString), handler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(JSONArray jsonArray, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTags()")) {
            return;
        }
        try {
            JSONObject jsonTags = new JSONObject();
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonTags.put(jsonArray.getString(i), (Object)"");
            }
            OneSignal.sendTags(jsonTags, handler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    static void sendPurchases(JSONArray purchases, boolean newAsExisting, OneSignalRestClient.ResponseHandler responseHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendPurchases()")) {
            return;
        }
        if (OneSignal.getUserId() == null) {
            iapUpdateJob = new IAPUpdateJob(purchases);
            OneSignal.iapUpdateJob.newAsExisting = newAsExisting;
            OneSignal.iapUpdateJob.restResponseHandler = responseHandler;
            return;
        }
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("app_id", (Object)OneSignal.getSavedAppId());
            if (newAsExisting) {
                jsonBody.put("existing", true);
            }
            jsonBody.put("purchases", (Object)purchases);
            OneSignalRestClient.post("players/" + OneSignal.getUserId() + "/on_purchase", jsonBody, responseHandler);
            if (OneSignal.getEmailId() != null) {
                OneSignalRestClient.post("players/" + OneSignal.getEmailId() + "/on_purchase", jsonBody, null);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for sendPurchases.", t);
        }
    }

    private static boolean openURLFromNotification(Context context, JSONArray dataArray) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return false;
        }
        int jsonArraySize = dataArray.length();
        boolean urlOpened = false;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                String url;
                JSONObject customJSON;
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom") || !(customJSON = new JSONObject(data.optString("custom"))).has("u") || (url = customJSON.optString("u", null)) == null) continue;
                OSUtils.openURLInBrowser(url);
                urlOpened = true;
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for launching a web URL.", t);
            }
        }
        return urlOpened;
    }

    private static void runNotificationOpenedCallback(JSONArray dataArray) {
        if (notificationOpenedHandler == null) {
            unprocessedOpenedNotifs.add(dataArray);
            return;
        }
        OneSignal.fireNotificationOpenedHandler(OneSignal.generateNotificationOpenedResult(dataArray));
    }

    @NonNull
    private static OSNotificationOpenedResult generateNotificationOpenedResult(JSONArray jsonArray) {
        int jsonArraySize = jsonArray.length();
        boolean firstMessage = true;
        int androidNotificationId = jsonArray.optJSONObject(0).optInt("androidNotificationId");
        ArrayList<OSNotification> groupedNotifications = new ArrayList<OSNotification>();
        String actionSelected = null;
        JSONObject payload = null;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                payload = jsonArray.getJSONObject(i);
                if (actionSelected == null && payload.has("actionId")) {
                    actionSelected = payload.optString("actionId", null);
                }
                if (firstMessage) {
                    firstMessage = false;
                    continue;
                }
                groupedNotifications.add(new OSNotification(payload));
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for callback.", t);
            }
        }
        OSNotificationAction.ActionType actionType = actionSelected != null ? OSNotificationAction.ActionType.ActionTaken : OSNotificationAction.ActionType.Opened;
        OSNotificationAction notificationAction = new OSNotificationAction(actionType, actionSelected);
        OSNotification notification = new OSNotification(groupedNotifications, payload, androidNotificationId);
        return new OSNotificationOpenedResult(notification, notificationAction);
    }

    private static void fireNotificationOpenedHandler(final OSNotificationOpenedResult openedResult) {
        OSUtils.runOnMainUIThread(new Runnable(){

            @Override
            public void run() {
                notificationOpenedHandler.notificationOpened(openedResult);
            }
        });
    }

    static void handleNotificationReceived(OSNotificationGenerationJob notificationJob) {
        try {
            JSONObject jsonObject = new JSONObject(notificationJob.getJsonPayload().toString());
            jsonObject.put("androidNotificationId", (Object)notificationJob.getAndroidId());
            OSNotificationOpenedResult openResult = OneSignal.generateNotificationOpenedResult(NotificationBundleProcessor.newJsonArray(jsonObject));
            if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled()) {
                trackFirebaseAnalytics.trackReceivedEvent(openResult);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static boolean shouldFireForegroundHandlers() {
        if (!OneSignal.isInForeground()) {
            OneSignal.onesignalLog(LOG_LEVEL.INFO, "App is in background, show notification");
            return false;
        }
        if (notificationWillShowInForegroundHandler == null) {
            OneSignal.onesignalLog(LOG_LEVEL.INFO, "No NotificationWillShowInForegroundHandler setup, show notification");
            return false;
        }
        return true;
    }

    static void fireForegroundHandlers(OSNotificationController notificationController) {
        OneSignal.onesignalLog(LOG_LEVEL.INFO, "Fire notificationWillShowInForegroundHandler");
        OSNotificationReceivedEvent notificationReceivedEvent = notificationController.getNotificationReceivedEvent();
        try {
            notificationWillShowInForegroundHandler.notificationWillShowInForeground(notificationReceivedEvent);
        }
        catch (Throwable t) {
            OneSignal.onesignalLog(LOG_LEVEL.ERROR, "Exception thrown while notification was being processed for display by notificationWillShowInForegroundHandler, showing notification in foreground!");
            notificationReceivedEvent.complete(notificationReceivedEvent.getNotification());
            throw t;
        }
    }

    static void handleNotificationOpen(Context context, final JSONArray data, final boolean fromAlert, final @Nullable String notificationId) {
        if (taskController.shouldQueueTaskForInit("handleNotificationOpen()")) {
            logger.error("Waiting for remote params. Moving handleNotificationOpen() operation to a pending queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    if (appContext != null) {
                        logger.debug("Running handleNotificationOpen() operation from pending queue.");
                        OneSignal.handleNotificationOpen(appContext, data, fromAlert, notificationId);
                    }
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return;
        }
        OneSignal.notificationOpenedRESTCall(context, data);
        if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled()) {
            trackFirebaseAnalytics.trackOpenedEvent(OneSignal.generateNotificationOpenedResult(data));
        }
        boolean urlOpened = false;
        boolean defaultOpenActionDisabled = "DISABLE".equals(OSUtils.getManifestMeta(context, "com.onesignal.NotificationOpened.DEFAULT"));
        if (!defaultOpenActionDisabled) {
            urlOpened = OneSignal.openURLFromNotification(context, data);
        }
        if (OneSignal.shouldInitDirectSessionFromNotificationOpen(context, fromAlert, urlOpened, defaultOpenActionDisabled)) {
            appEntryState = AppEntryAction.NOTIFICATION_CLICK;
            sessionManager.onDirectInfluenceFromNotificationOpen(appEntryState, notificationId);
        }
        OneSignal.runNotificationOpenedCallback(data);
    }

    static boolean startOrResumeApp(Context inContext) {
        Intent launchIntent = inContext.getPackageManager().getLaunchIntentForPackage(inContext.getPackageName());
        if (launchIntent != null) {
            launchIntent.setFlags(0x10020000);
            inContext.startActivity(launchIntent);
            return true;
        }
        return false;
    }

    private static boolean shouldInitDirectSessionFromNotificationOpen(Context context, boolean fromAlert, boolean urlOpened, boolean defaultOpenActionDisabled) {
        return !fromAlert && !urlOpened && !defaultOpenActionDisabled && !inForeground && OneSignal.startOrResumeApp(context);
    }

    private static void notificationOpenedRESTCall(Context inContext, JSONArray dataArray) {
        for (int i = 0; i < dataArray.length(); ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                JSONObject customJson = new JSONObject(data.optString("custom", null));
                String notificationId = customJson.optString("i", null);
                if (postedOpenedNotifIds.contains(notificationId)) continue;
                postedOpenedNotifIds.add(notificationId);
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("app_id", (Object)OneSignal.getSavedAppId(inContext));
                jsonBody.put("player_id", (Object)OneSignal.getSavedUserId(inContext));
                jsonBody.put("opened", true);
                jsonBody.put("device_type", osUtils.getDeviceType());
                OneSignalRestClient.put("notifications/" + notificationId, jsonBody, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("sending Notification Opened Failed", statusCode, throwable, response);
                    }
                });
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON to send notification opened.", t);
            }
        }
    }

    private static void saveAppId(String appId) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_APP_ID", appId);
    }

    static String getSavedAppId() {
        return OneSignal.getSavedAppId(appContext);
    }

    private static String getSavedAppId(Context inContext) {
        if (inContext == null) {
            return null;
        }
        return OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_APP_ID", null);
    }

    private static String getSavedUserId(Context inContext) {
        if (inContext == null) {
            return null;
        }
        return OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_PLAYER_ID", null);
    }

    static boolean hasUserId() {
        return OneSignal.getUserId() != null;
    }

    static String getUserId() {
        if (userId == null && appContext != null) {
            userId = OneSignal.getSavedUserId(appContext);
        }
        return userId;
    }

    static void saveUserId(String id2) {
        userId = id2;
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_PLAYER_ID", userId);
    }

    static boolean hasEmailId() {
        return !TextUtils.isEmpty((CharSequence)emailId);
    }

    static String getEmailId() {
        if (TextUtils.isEmpty((CharSequence)emailId) && appContext != null) {
            emailId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "OS_EMAIL_ID", null);
        }
        return emailId;
    }

    static void saveEmailId(String id2) {
        emailId = id2;
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "OS_EMAIL_ID", "".equals(emailId) ? null : emailId);
    }

    static void updateUserIdDependents(String userId) {
        OneSignal.saveUserId(userId);
        OneSignal.internalFireGetTagsCallbacks();
        OneSignal.getCurrentSubscriptionState(appContext).setUserId(userId);
        if (iapUpdateJob != null) {
            OneSignal.sendPurchases(OneSignal.iapUpdateJob.toReport, OneSignal.iapUpdateJob.newAsExisting, OneSignal.iapUpdateJob.restResponseHandler);
            iapUpdateJob = null;
        }
        OneSignalStateSynchronizer.refreshEmailState();
        OneSignalChromeTabAndroidFrame.setup(appId, userId, AdvertisingIdProviderGPS.getLastValue(), OneSignal.getRemoteParams());
    }

    static void updateEmailIdDependents(String emailId) {
        OneSignal.saveEmailId(emailId);
        OneSignal.getCurrentEmailSubscriptionState(appContext).setEmailUserId(emailId);
        try {
            JSONObject updateJson = new JSONObject().put("parent_player_id", (Object)emailId);
            OneSignalStateSynchronizer.updatePushState(updateJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static boolean getFirebaseAnalyticsEnabled() {
        return remoteParamController.getFirebaseAnalyticsEnabled();
    }

    static boolean getClearGroupSummaryClick() {
        return remoteParamController.getClearGroupSummaryClick();
    }

    static boolean getDisableGMSMissingPrompt() {
        return remoteParamController.isGMSMissingPromptDisable();
    }

    static boolean isLocationShared() {
        return remoteParamController.isLocationShared();
    }

    static boolean isUserPrivacyConsentRequired() {
        return remoteParamController.isPrivacyConsentRequired();
    }

    static void setLastSessionTime(long time) {
        OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_SESSION_TIME", time);
    }

    private static long getLastSessionTime() {
        return OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_SESSION_TIME", -31000L);
    }

    public static void disablePush(final boolean disable) {
        if (taskController.shouldQueueTaskForInit("setSubscription()")) {
            logger.error("Waiting for remote params. Moving setSubscription() operation to a pending queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running setSubscription() operation from pending queue.");
                    OneSignal.disablePush(disable);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setSubscription()")) {
            return;
        }
        OneSignal.getCurrentSubscriptionState(appContext).setPushDisabled(disable);
        OneSignalStateSynchronizer.setSubscription(!disable);
    }

    public static void setLocationShared(final boolean enable) {
        if (taskController.shouldQueueTaskForInit("setLocationShared()")) {
            logger.error("Waiting for remote params. Moving setLocationShared() operation to a pending task queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running setLocationShared() operation from pending task queue.");
                    OneSignal.setLocationShared(enable);
                }
            });
            return;
        }
        if (OneSignal.getRemoteParamController().hasLocationKey()) {
            return;
        }
        OneSignal.startLocationShared(enable);
    }

    static void startLocationShared(boolean enable) {
        logger.debug("OneSignal is shareLocation enabled: " + enable);
        OneSignal.getRemoteParamController().saveLocationShared(enable);
        if (!enable) {
            logger.debug("OneSignal is shareLocation set false, clearing last location!");
            OneSignalStateSynchronizer.clearLocation();
        }
    }

    public static void promptLocation() {
        OneSignal.promptLocation(null, false);
    }

    static void promptLocation(final @Nullable OSPromptActionCompletionCallback callback, final boolean fallbackToSettings) {
        if (taskController.shouldQueueTaskForInit("promptLocation()")) {
            logger.error("Waiting for remote params. Moving promptLocation() operation to a pending queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running promptLocation() operation from pending queue.");
                    OneSignal.promptLocation(callback, fallbackToSettings);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("promptLocation()")) {
            return;
        }
        LocationController.LocationPromptCompletionHandler locationHandler = new LocationController.LocationPromptCompletionHandler(){

            @Override
            public LocationController.PermissionType getType() {
                return LocationController.PermissionType.PROMPT_LOCATION;
            }

            @Override
            public void onComplete(LocationController.LocationPoint point) {
                if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("promptLocation()")) {
                    return;
                }
                if (point != null) {
                    OneSignalStateSynchronizer.updateLocation(point);
                }
            }

            @Override
            void onAnswered(PromptActionResult result) {
                super.onAnswered(result);
                if (callback != null) {
                    callback.onCompleted(result);
                }
            }
        };
        LocationController.getLocation(appContext, true, fallbackToSettings, locationHandler);
        promptedLocation = true;
    }

    public static void clearOneSignalNotifications() {
        Runnable runClearOneSignalNotifications = new Runnable(){

            @Override
            public void run() {
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                OneSignalDbHelper dbHelper = OneSignal.getDBHelperInstance();
                String[] retColumn = new String[]{"android_notification_id"};
                Cursor cursor = dbHelper.query("notification", retColumn, "dismissed = 0 AND opened = 0", null, null, null, null);
                if (cursor.moveToFirst()) {
                    do {
                        int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                        notificationManager.cancel(existingId);
                    } while (cursor.moveToNext());
                }
                String whereStr = "opened = 0";
                ContentValues values = new ContentValues();
                values.put("dismissed", Integer.valueOf(1));
                dbHelper.update("notification", values, whereStr, null);
                BadgeCountUpdater.updateCount(0, appContext);
                cursor.close();
            }
        };
        if (OSUtils.isRunningOnMainThread()) {
            new Thread(runClearOneSignalNotifications, "OS_NOTIFICATIONS").start();
        } else {
            runClearOneSignalNotifications.run();
        }
    }

    public static void cancelNotification(final int id2) {
        Runnable runCancelNotification = new Runnable(){

            @Override
            public void run() {
                OneSignalDbHelper dbHelper = OneSignal.getDBHelperInstance();
                String whereStr = "android_notification_id = " + id2 + " AND " + "opened" + " = 0 AND " + "dismissed" + " = 0";
                ContentValues values = new ContentValues();
                values.put("dismissed", Integer.valueOf(1));
                int records = dbHelper.update("notification", values, whereStr, null);
                if (records > 0) {
                    NotificationSummaryManager.updatePossibleDependentSummaryOnDismiss(appContext, dbHelper, id2);
                }
                BadgeCountUpdater.update(dbHelper, appContext);
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                notificationManager.cancel(id2);
            }
        };
        if (OSUtils.isRunningOnMainThread()) {
            new Thread(runCancelNotification, "OS_NOTIFICATIONS").start();
        } else {
            runCancelNotification.run();
        }
    }

    public static void cancelGroupedNotifications(final String group) {
        if (taskController.shouldQueueTaskForInit("cancelGroupedNotifications()")) {
            logger.error("Waiting for remote params. Moving cancelGroupedNotifications() operation to a pending queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running cancelGroupedNotifications() operation from pending queue.");
                    OneSignal.cancelGroupedNotifications(group);
                }
            });
            return;
        }
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("cancelGroupedNotifications()")) {
            return;
        }
        Runnable runCancelGroupedNotifications = new Runnable(){

            @Override
            public void run() {
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                OneSignalDbHelper dbHelper = OneSignal.getDBHelperInstance();
                String[] retColumn = new String[]{"android_notification_id"};
                String[] whereArgs = new String[]{group};
                String whereStr = "group_id = ? AND dismissed = 0 AND opened = 0";
                Cursor cursor = dbHelper.query("notification", retColumn, whereStr, whereArgs, null, null, null);
                while (cursor.moveToNext()) {
                    int notificationId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                    if (notificationId == -1) continue;
                    notificationManager.cancel(notificationId);
                }
                cursor.close();
                whereStr = "group_id = ? AND opened = 0 AND dismissed = 0";
                ContentValues values = new ContentValues();
                values.put("dismissed", Integer.valueOf(1));
                dbHelper.update("notification", values, whereStr, whereArgs);
                BadgeCountUpdater.update(dbHelper, appContext);
            }
        };
        if (OSUtils.isRunningOnMainThread()) {
            new Thread(runCancelGroupedNotifications, "OS_NOTIFICATIONS").start();
        } else {
            runCancelGroupedNotifications.run();
        }
    }

    public static void addPermissionObserver(OSPermissionObserver observer) {
        if (appContext == null) {
            logger.error("OneSignal.initWithContext has not been called. Could not add permission observer");
            return;
        }
        OneSignal.getPermissionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentPermissionState(appContext).compare(OneSignal.getLastPermissionState(appContext))) {
            OSPermissionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentPermissionState(appContext));
        }
    }

    public static void removePermissionObserver(OSPermissionObserver observer) {
        if (appContext == null) {
            logger.error("OneSignal.initWithContext has not been called. Could not modify permission observer");
            return;
        }
        OneSignal.getPermissionStateChangesObserver().removeObserver(observer);
    }

    public static void addSubscriptionObserver(OSSubscriptionObserver observer) {
        if (appContext == null) {
            logger.error("OneSignal.initWithContext has not been called. Could not add subscription observer");
            return;
        }
        OneSignal.getSubscriptionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentSubscriptionState(appContext).compare(OneSignal.getLastSubscriptionState(appContext))) {
            OSSubscriptionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentSubscriptionState(appContext));
        }
    }

    public static void removeSubscriptionObserver(OSSubscriptionObserver observer) {
        if (appContext == null) {
            logger.error("OneSignal.initWithContext has not been called. Could not modify subscription observer");
            return;
        }
        OneSignal.getSubscriptionStateChangesObserver().removeObserver(observer);
    }

    public static void addEmailSubscriptionObserver(@NonNull OSEmailSubscriptionObserver observer) {
        if (appContext == null) {
            logger.error("OneSignal.initWithContext has not been called. Could not add email subscription observer");
            return;
        }
        OneSignal.getEmailSubscriptionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentEmailSubscriptionState(appContext).compare(OneSignal.getLastEmailSubscriptionState(appContext))) {
            OSEmailSubscriptionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentEmailSubscriptionState(appContext));
        }
    }

    public static void removeEmailSubscriptionObserver(@NonNull OSEmailSubscriptionObserver observer) {
        if (appContext == null) {
            logger.error("OneSignal.initWithContext has not been called. Could not modify email subscription observer");
            return;
        }
        OneSignal.getEmailSubscriptionStateChangesObserver().removeObserver(observer);
    }

    public static void addTriggers(Map<String, Object> triggers) {
        OneSignal.getInAppMessageController().addTriggers(triggers);
    }

    public static void addTriggersFromJsonString(String triggersJsonString) {
        try {
            JSONObject jsonObject = new JSONObject(triggersJsonString);
            OneSignal.addTriggers(JSONUtils.jsonObjectToMap(jsonObject));
        }
        catch (JSONException e) {
            logger.error("addTriggersFromJsonString, invalid json", e);
        }
    }

    public static void addTrigger(String key, Object object) {
        HashMap<String, Object> triggerMap = new HashMap<String, Object>();
        triggerMap.put(key, object);
        OneSignal.getInAppMessageController().addTriggers(triggerMap);
    }

    public static void removeTriggersForKeys(Collection<String> keys) {
        OneSignal.getInAppMessageController().removeTriggersForKeys(keys);
    }

    public static void removeTriggersForKeysFromJsonArrayString(@NonNull String keys) {
        try {
            JSONArray jsonArray = new JSONArray(keys);
            Collection<String> keysCollection = OSUtils.extractStringsFromCollection(JSONUtils.jsonArrayToList(jsonArray));
            if (jsonArray.length() != keysCollection.size()) {
                OneSignal.Log(LOG_LEVEL.WARN, "removeTriggersForKeysFromJsonArrayString: Skipped removing non-String type keys ");
            }
            OneSignal.getInAppMessageController().removeTriggersForKeys(keysCollection);
        }
        catch (JSONException e) {
            logger.error("removeTriggersForKeysFromJsonArrayString, invalid json", e);
        }
    }

    public static void removeTriggerForKey(String key) {
        ArrayList<String> triggerKeys = new ArrayList<String>();
        triggerKeys.add(key);
        OneSignal.getInAppMessageController().removeTriggersForKeys(triggerKeys);
    }

    @Nullable
    public static Object getTriggerValueForKey(String key) {
        return OneSignal.getInAppMessageController().getTriggerValue(key);
    }

    public static void pauseInAppMessages(final boolean pause) {
        if (appContext == null) {
            logger.error("Waiting initWithContext. Moving pauseInAppMessages() operation to a pending task queue.");
            taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Running pauseInAppMessages() operation from pending queue.");
                    OneSignal.pauseInAppMessages(pause);
                }
            });
            return;
        }
        OneSignal.getInAppMessageController().setInAppMessagingEnabled(!pause);
    }

    private static boolean isDuplicateNotification(Context context, String id2) {
        if (id2 == null || "".equals(id2)) {
            return false;
        }
        OneSignalDbHelper dbHelper = OneSignal.getDBHelperInstance();
        String[] retColumn = new String[]{"notification_id"};
        String[] whereArgs = new String[]{id2};
        Cursor cursor = dbHelper.query("notification", retColumn, "notification_id = ?", whereArgs, null, null, null);
        boolean exists = cursor.moveToFirst();
        cursor.close();
        if (exists) {
            logger.debug("Duplicate FCM message received, skip processing of " + id2);
            return true;
        }
        return false;
    }

    static boolean notValidOrDuplicated(Context context, JSONObject jsonPayload) {
        String id2 = OSNotificationFormatHelper.getOSNotificationIdFromJson(jsonPayload);
        return id2 == null || OneSignal.isDuplicateNotification(context, id2);
    }

    static String getNotificationIdFromFCMJson(@Nullable JSONObject fcmJson) {
        if (fcmJson == null) {
            return null;
        }
        try {
            JSONObject customJSON = new JSONObject(fcmJson.getString("custom"));
            if (customJSON.has("i")) {
                return customJSON.optString("i", null);
            }
            logger.debug("Not a OneSignal formatted FCM message. No 'i' field in custom.");
        }
        catch (JSONException e) {
            logger.debug("Not a OneSignal formatted FCM message. No 'custom' field in the JSONObject.");
        }
        return null;
    }

    static String getNotificationIdFromFCMBundle(@Nullable Bundle fcmBundle) {
        if (fcmBundle == null || fcmBundle.isEmpty()) {
            return null;
        }
        try {
            if (fcmBundle.containsKey("custom")) {
                JSONObject customJSON = new JSONObject(fcmBundle.getString("custom"));
                if (customJSON.has("i")) {
                    return customJSON.optString("i", null);
                }
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted FCM message. No 'i' field in custom.");
            } else {
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted FCM message. No 'custom' field in the bundle.");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Could not parse bundle, probably not a OneSignal notification.", t);
        }
        return null;
    }

    private static String getNotificationIdFromFCMJsonPayload(JSONObject fcmJson) {
        try {
            JSONObject customJSON = new JSONObject(fcmJson.optString("custom"));
            return customJSON.optString("i", null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static boolean isAppActive() {
        return initDone && OneSignal.isInForeground();
    }

    private static boolean isPastOnSessionTime() {
        return OneSignal.getTime().getCurrentTimeMillis() - OneSignal.getLastSessionTime() >= 30000L;
    }

    static boolean areNotificationsEnabledForSubscribedState() {
        if (remoteParamController.unsubscribeWhenNotificationsAreDisabled()) {
            return OSUtils.areNotificationsEnabled(appContext);
        }
        return true;
    }

    static void handleSuccessfulEmailLogout() {
        if (emailLogoutHandler != null) {
            emailLogoutHandler.onSuccess();
            emailLogoutHandler = null;
        }
    }

    static void handleFailedEmailLogout() {
        if (emailLogoutHandler != null) {
            emailLogoutHandler.onFailure(new EmailUpdateError(EmailErrorType.NETWORK, "Failed due to network failure. Will retry on next sync."));
            emailLogoutHandler = null;
        }
    }

    static void fireEmailUpdateSuccess() {
        if (emailUpdateHandler != null) {
            emailUpdateHandler.onSuccess();
            emailUpdateHandler = null;
        }
    }

    static void fireEmailUpdateFailure() {
        if (emailUpdateHandler != null) {
            emailUpdateHandler.onFailure(new EmailUpdateError(EmailErrorType.NETWORK, "Failed due to network failure. Will retry on next sync."));
            emailUpdateHandler = null;
        }
    }

    @NonNull
    static OSTime getTime() {
        return time;
    }

    static void setTime(OSTime time) {
        OneSignal.time = time;
    }

    static void setTrackerFactory(OSTrackerFactory trackerFactory) {
        OneSignal.trackerFactory = trackerFactory;
    }

    static void setSessionManager(OSSessionManager sessionManager) {
        OneSignal.sessionManager = sessionManager;
    }

    static void setSharedPreferences(OSSharedPreferences preferences) {
        OneSignal.preferences = preferences;
    }

    static OSSessionManager.SessionListener getSessionListener() {
        return sessionListener;
    }

    static OSRemoteParamController getRemoteParamController() {
        return remoteParamController;
    }

    static OneSignalDbHelper getDBHelperInstance() {
        return OneSignalDbHelper.getInstance(appContext);
    }

    static OSTaskController getTaskController() {
        return taskController;
    }

    static OSSessionManager getSessionManager() {
        return sessionManager;
    }

    static void sendClickActionOutcomes(@NonNull List<OSInAppMessageOutcome> outcomes) {
        if (outcomeEventsController == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Make sure OneSignal.init is called first");
            return;
        }
        outcomeEventsController.sendClickActionOutcomes(outcomes);
    }

    public static void sendOutcome(@NonNull String name) {
        OneSignal.sendOutcome(name, null);
    }

    public static void sendOutcome(@NonNull String name, OutcomeCallback callback) {
        if (!OneSignal.isValidOutcomeEntry(name)) {
            logger.error("Make sure OneSignal initWithContext and setAppId is called first");
            return;
        }
        if (outcomeEventsController == null) {
            logger.error("Make sure OneSignal initWithContext and setAppId is called first");
            return;
        }
        outcomeEventsController.sendOutcomeEvent(name, callback);
    }

    public static void sendUniqueOutcome(@NonNull String name) {
        OneSignal.sendUniqueOutcome(name, null);
    }

    public static void sendUniqueOutcome(@NonNull String name, OutcomeCallback callback) {
        if (!OneSignal.isValidOutcomeEntry(name)) {
            return;
        }
        if (outcomeEventsController == null) {
            logger.error("Make sure OneSignal initWithContext and setAppId is called first");
            return;
        }
        outcomeEventsController.sendUniqueOutcomeEvent(name, callback);
    }

    public static void sendOutcomeWithValue(@NonNull String name, float value) {
        OneSignal.sendOutcomeWithValue(name, value, null);
    }

    public static void sendOutcomeWithValue(@NonNull String name, float value, OutcomeCallback callback) {
        if (!OneSignal.isValidOutcomeEntry(name) || !OneSignal.isValidOutcomeValue(value)) {
            return;
        }
        if (outcomeEventsController == null) {
            logger.error("Make sure OneSignal.init is called first");
            return;
        }
        outcomeEventsController.sendOutcomeEventWithValue(name, value, callback);
    }

    private static boolean isValidOutcomeEntry(String name) {
        if (name == null || name.isEmpty()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Outcome name must not be empty");
            return false;
        }
        return true;
    }

    private static boolean isValidOutcomeValue(float value) {
        if (value <= 0.0f) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Outcome value must be greater than 0");
            return false;
        }
        return true;
    }

    static {
        visualLogLevel = LOG_LEVEL.NONE;
        logCatLevel = LOG_LEVEL.WARN;
        userId = null;
        emailId = null;
        subscribableStatus = Integer.MAX_VALUE;
        appEntryState = AppEntryAction.APP_CLOSE;
        sessionListener = new OSSessionManager.SessionListener(){

            @Override
            public void onSessionEnding(@NonNull List<OSInfluence> lastInfluences) {
                if (outcomeEventsController == null) {
                    OneSignal.Log(LOG_LEVEL.WARN, "OneSignal onSessionEnding called before init!");
                }
                if (outcomeEventsController != null) {
                    outcomeEventsController.cleanOutcomes();
                }
                FocusTimeController.getInstance().onSessionEnded(lastInfluences);
            }
        };
        inAppMessageControllerFactory = new OSInAppMessageControllerFactory();
        time = new OSTimeImpl();
        logger = new OSLogWrapper();
        remoteParamController = new OSRemoteParamController();
        taskController = new OSTaskController(remoteParamController, logger);
        apiClient = new OneSignalRestClientWrapper();
        preferences = new OSSharedPreferencesWrapper();
        trackerFactory = new OSTrackerFactory(preferences, logger, time);
        sessionManager = new OSSessionManager(sessionListener, trackerFactory, logger);
        sdkType = "native";
        osUtils = new OSUtils();
        unprocessedOpenedNotifs = new ArrayList<JSONArray>();
        postedOpenedNotifIds = new HashSet();
        pendingGetTagsHandlers = new ArrayList();
    }

    static enum PromptActionResult {
        PERMISSION_GRANTED,
        PERMISSION_DENIED,
        LOCATION_PERMISSIONS_MISSING_MANIFEST,
        ERROR;

    }

    static interface OSPromptActionCompletionCallback {
        public void onCompleted(PromptActionResult var1);
    }

    public static interface OutcomeCallback {
        public void onSuccess(@Nullable OutcomeEvent var1);
    }

    private static class IAPUpdateJob {
        JSONArray toReport;
        boolean newAsExisting;
        OneSignalRestClient.ResponseHandler restResponseHandler;

        IAPUpdateJob(JSONArray toReport) {
            this.toReport = toReport;
        }
    }

    public static interface PostNotificationResponseHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(JSONObject var1);
    }

    public static interface EmailUpdateHandler {
        public void onSuccess();

        public void onFailure(EmailUpdateError var1);
    }

    public static class EmailUpdateError {
        private EmailErrorType type;
        private String message;

        EmailUpdateError(EmailErrorType type, String message) {
            this.type = type;
            this.message = message;
        }

        public EmailErrorType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum EmailErrorType {
        VALIDATION,
        REQUIRES_EMAIL_AUTH,
        INVALID_OPERATION,
        NETWORK;

    }

    static interface OSInternalExternalUserIdUpdateCompletionHandler {
        public void onComplete(String var1, boolean var2);
    }

    public static interface OSExternalUserIdUpdateCompletionHandler {
        public void onComplete(JSONObject var1);
    }

    public static class SendTagsError {
        private String message;
        private int code;

        SendTagsError(int errorCode, String errorMessage) {
            this.message = errorMessage;
            this.code = errorCode;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static interface ChangeTagsUpdateHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(SendTagsError var1);
    }

    public static interface OSGetTagsHandler {
        public void tagsAvailable(JSONObject var1);
    }

    public static interface OSInAppMessageClickHandler {
        public void inAppMessageClicked(OSInAppMessageAction var1);
    }

    public static interface OSNotificationOpenedHandler {
        public void notificationOpened(OSNotificationOpenedResult var1);
    }

    public static interface OSNotificationWillShowInForegroundHandler {
        public void notificationWillShowInForeground(OSNotificationReceivedEvent var1);
    }

    public static interface OSRemoteNotificationReceivedHandler {
        public void remoteNotificationReceived(Context var1, OSNotificationReceivedEvent var2);
    }

    public static enum AppEntryAction {
        NOTIFICATION_CLICK,
        APP_OPEN,
        APP_CLOSE;


        public boolean isNotificationClick() {
            return this.equals((Object)NOTIFICATION_CLICK);
        }

        public boolean isAppOpen() {
            return this.equals((Object)APP_OPEN);
        }

        public boolean isAppClose() {
            return this.equals((Object)APP_CLOSE);
        }
    }

    public static enum LOG_LEVEL {
        NONE,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        VERBOSE;

    }
}

