/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence.data;

import com.onesignal.OSLogger;
import com.onesignal.OSTime;
import com.onesignal.influence.data.OSChannelTracker;
import com.onesignal.influence.data.OSInfluenceDataRepository;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.influence.domain.OSInfluenceChannel;
import com.onesignal.influence.domain.OSInfluenceType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\u0012\u0010\"\u001a\u00020\u00182\b\u0010#\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010$\u001a\u00020\u001cH\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0018H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/onesignal/influence/data/OSNotificationTracker;", "Lcom/onesignal/influence/data/OSChannelTracker;", "dataRepository", "Lcom/onesignal/influence/data/OSInfluenceDataRepository;", "logger", "Lcom/onesignal/OSLogger;", "timeProvider", "Lcom/onesignal/OSTime;", "(Lcom/onesignal/influence/data/OSInfluenceDataRepository;Lcom/onesignal/OSLogger;Lcom/onesignal/OSTime;)V", "channelLimit", "", "getChannelLimit", "()I", "channelType", "Lcom/onesignal/influence/domain/OSInfluenceChannel;", "getChannelType", "()Lcom/onesignal/influence/domain/OSInfluenceChannel;", "idTag", "", "getIdTag", "()Ljava/lang/String;", "indirectAttributionWindow", "getIndirectAttributionWindow", "lastChannelObjects", "Lorg/json/JSONArray;", "getLastChannelObjects", "()Lorg/json/JSONArray;", "addSessionData", "", "jsonObject", "Lorg/json/JSONObject;", "influence", "Lcom/onesignal/influence/domain/OSInfluence;", "cacheState", "getLastChannelObjectsReceivedByNewId", "id", "initInfluencedTypeFromCache", "saveChannelObjects", "channelObjects", "onesignal_release"})
public final class OSNotificationTracker
extends OSChannelTracker {
    @Override
    @NotNull
    public JSONArray getLastChannelObjectsReceivedByNewId(@Nullable String id2) {
        JSONArray jSONArray;
        try {
            jSONArray = this.getLastChannelObjects();
        }
        catch (JSONException exception) {
            this.getLogger().error("Generating Notification tracker getLastChannelObjects JSONObject ", exception);
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    @Override
    @NotNull
    public JSONArray getLastChannelObjects() throws JSONException {
        return this.getDataRepository().getLastNotificationsReceivedData();
    }

    @Override
    @NotNull
    public String getIdTag() {
        return "notification_id";
    }

    @Override
    @NotNull
    public OSInfluenceChannel getChannelType() {
        return OSInfluenceChannel.NOTIFICATION;
    }

    @Override
    public int getChannelLimit() {
        return this.getDataRepository().getNotificationLimit();
    }

    @Override
    public int getIndirectAttributionWindow() {
        return this.getDataRepository().getNotificationIndirectAttributionWindow();
    }

    @Override
    public void saveChannelObjects(@NotNull JSONArray channelObjects) {
        Intrinsics.checkParameterIsNotNull((Object)channelObjects, (String)"channelObjects");
        this.getDataRepository().saveNotifications(channelObjects);
    }

    @Override
    public void initInfluencedTypeFromCache() {
        OSInfluenceType oSInfluenceType = this.getDataRepository().getNotificationCachedInfluenceType();
        OSNotificationTracker oSNotificationTracker = this;
        boolean bl = false;
        boolean bl2 = false;
        OSInfluenceType it = oSInfluenceType;
        boolean bl3 = false;
        if (it.isIndirect()) {
            this.setIndirectIds(this.getLastReceivedIds());
        } else if (it.isDirect()) {
            this.setDirectId(this.getDataRepository().getCachedNotificationOpenId());
        }
        OSInfluenceType oSInfluenceType2 = oSInfluenceType;
        oSNotificationTracker.setInfluenceType(oSInfluenceType2);
        this.getLogger().debug("OneSignal NotificationTracker initInfluencedTypeFromCache: " + this);
    }

    @Override
    public void addSessionData(@NotNull JSONObject jsonObject, @NotNull OSInfluence influence) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull((Object)influence, (String)"influence");
        if (influence.getInfluenceType().isAttributed()) {
            try {
                jsonObject.put("direct", influence.getInfluenceType().isDirect());
                jsonObject.put("notification_ids", (Object)influence.getIds());
            }
            catch (JSONException exception) {
                this.getLogger().error("Generating notification tracker addSessionData JSONObject ", exception);
            }
        }
    }

    @Override
    public void cacheState() {
        OSInfluenceDataRepository oSInfluenceDataRepository = this.getDataRepository();
        OSInfluenceType oSInfluenceType = this.getInfluenceType();
        if (oSInfluenceType == null) {
            oSInfluenceType = OSInfluenceType.UNATTRIBUTED;
        }
        oSInfluenceDataRepository.cacheNotificationInfluenceType(oSInfluenceType);
        this.getDataRepository().cacheNotificationOpenId(this.getDirectId());
    }

    public OSNotificationTracker(@NotNull OSInfluenceDataRepository dataRepository, @NotNull OSLogger logger, @NotNull OSTime timeProvider) {
        Intrinsics.checkParameterIsNotNull((Object)dataRepository, (String)"dataRepository");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)timeProvider, (String)"timeProvider");
        super(dataRepository, logger, timeProvider);
    }
}

