/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import androidx.annotation.WorkerThread;
import com.onesignal.OSInAppMessageController;
import com.onesignal.OSInAppMessageRepository;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.influence.domain.OSInfluenceChannel;

class OneSignalCacheCleaner {
    private static final long NOTIFICATION_CACHE_DATA_LIFETIME = 604800L;
    private static final String OS_DELETE_CACHED_NOTIFICATIONS_THREAD = "OS_DELETE_CACHED_NOTIFICATIONS_THREAD";
    private static final String OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD = "OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD";

    OneSignalCacheCleaner() {
    }

    static void cleanOldCachedData(Context context) {
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        SQLiteDatabase writableDb = dbHelper.getSQLiteDatabaseWithRetries();
        OneSignalCacheCleaner.cleanNotificationCache(writableDb);
        OneSignalCacheCleaner.cleanCachedInAppMessages(dbHelper);
    }

    static synchronized void cleanNotificationCache(final SQLiteDatabase writableDb) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                writableDb.beginTransaction();
                try {
                    OneSignalCacheCleaner.cleanCachedNotifications(writableDb);
                    OneSignalCacheCleaner.cleanCachedUniqueOutcomeEventNotifications(writableDb);
                    writableDb.setTransactionSuccessful();
                }
                finally {
                    try {
                        writableDb.endTransaction();
                    }
                    catch (SQLException t) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                    }
                }
            }
        }, OS_DELETE_CACHED_NOTIFICATIONS_THREAD).start();
    }

    @WorkerThread
    static synchronized void cleanCachedInAppMessages(final OneSignalDbHelper dbHelper) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OSInAppMessageRepository inAppMessageRepository = OSInAppMessageController.getController(OneSignal.getLogger()).getInAppMessageRepository(dbHelper);
                inAppMessageRepository.cleanCachedInAppMessages();
            }
        }, OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD).start();
    }

    private static void cleanCachedNotifications(SQLiteDatabase writableDb) {
        String whereStr = "created_time < ?";
        String sevenDaysAgoInSeconds = String.valueOf(OneSignal.getTime().getCurrentTimeMillis() / 1000L - 604800L);
        String[] whereArgs = new String[]{sevenDaysAgoInSeconds};
        writableDb.delete("notification", whereStr, whereArgs);
    }

    private static void cleanCachedUniqueOutcomeEventNotifications(SQLiteDatabase writableDb) {
        String whereStr = "NOT EXISTS(SELECT NULL FROM notification n WHERE n.notification_id = channel_influence_id AND channel_type = \"" + OSInfluenceChannel.NOTIFICATION.toString().toLowerCase() + "\")";
        writableDb.delete("cached_unique_outcome", whereStr, null);
    }
}

