/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OSEmailSubscriptionState;
import com.onesignal.OSPermissionState;
import com.onesignal.OSPermissionSubscriptionState;
import com.onesignal.OSSubscriptionState;
import org.json.JSONObject;

public class OSDeviceState {
    private final boolean areNotificationsEnabled;
    private final boolean pushDisabled;
    private final boolean subscribed;
    private final String userId;
    private final String pushToken;
    private final String emailUserId;
    private final String emailAddress;

    public OSDeviceState(OSPermissionSubscriptionState permissionSubscriptionState) {
        OSSubscriptionState subscriptionStatus = permissionSubscriptionState.subscriptionStatus;
        OSPermissionState permissionStatus = permissionSubscriptionState.permissionStatus;
        OSEmailSubscriptionState emailSubscriptionStatus = permissionSubscriptionState.emailSubscriptionStatus;
        this.areNotificationsEnabled = permissionStatus.getEnabled();
        this.pushDisabled = !subscriptionStatus.getUserSubscriptionSetting();
        this.subscribed = subscriptionStatus.getSubscribed();
        this.userId = subscriptionStatus.getUserId();
        this.pushToken = subscriptionStatus.getPushToken();
        this.emailUserId = emailSubscriptionStatus.getEmailUserId();
        this.emailAddress = emailSubscriptionStatus.getEmailAddress();
    }

    public boolean areNotificationsEnabled() {
        return this.areNotificationsEnabled;
    }

    public boolean isPushDisabled() {
        return this.pushDisabled;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPushToken() {
        return this.pushToken;
    }

    public String getEmailUserId() {
        return this.emailUserId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("areNotificationsEnabled", this.areNotificationsEnabled);
            mainObj.put("isPushDisabled", this.pushDisabled);
            mainObj.put("isSubscribed", this.subscribed);
            mainObj.put("userId", (Object)this.userId);
            mainObj.put("pushToken", (Object)this.pushToken);
            mainObj.put("emailUserId", (Object)this.emailUserId);
            mainObj.put("emailAddress", (Object)this.emailAddress);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return mainObj;
    }
}

