/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import com.onesignal.OSSystemConditionController;
import com.onesignal.OSUtils;
import com.onesignal.OSViewUtils;
import com.onesignal.OneSignal;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class ActivityLifecycleHandler
implements OSSystemConditionController.OSSystemConditionHandler {
    private static final Map<String, ActivityAvailableListener> sActivityAvailableListeners = new ConcurrentHashMap<String, ActivityAvailableListener>();
    private static final Map<String, OSSystemConditionController.OSSystemConditionObserver> sSystemConditionObservers = new ConcurrentHashMap<String, OSSystemConditionController.OSSystemConditionObserver>();
    private static final Map<String, KeyboardListener> sKeyboardListeners = new ConcurrentHashMap<String, KeyboardListener>();
    private final FocusHandlerThread focusHandlerThread = new FocusHandlerThread();
    @SuppressLint(value={"StaticFieldLeak"})
    private Activity curActivity = null;
    private boolean nextResumeIsFirstActivity = false;

    ActivityLifecycleHandler() {
    }

    void onConfigurationChanged(Configuration newConfig) {
        if (this.curActivity != null && OSUtils.hasConfigChangeFlag(this.curActivity, 128)) {
            this.logOrientationChange(newConfig.orientation);
            this.onOrientationChanged();
        }
    }

    void onActivityCreated(Activity activity) {
    }

    void onActivityStarted(Activity activity) {
    }

    void onActivityResumed(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityResumed: " + activity);
        this.setCurActivity(activity);
        this.logCurActivity();
        this.handleFocus();
    }

    void onActivityPaused(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityPaused: " + activity);
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        this.logCurActivity();
    }

    void onActivityStopped(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityStopped: " + activity);
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().stopped(new WeakReference<Activity>(activity));
        }
        this.logCurActivity();
    }

    void onActivityDestroyed(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityDestroyed: " + activity);
        sKeyboardListeners.clear();
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        this.logCurActivity();
    }

    private void logCurActivity() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "curActivity is NOW: " + (this.curActivity != null ? "" + this.curActivity.getClass().getName() + ":" + this.curActivity : "null"));
    }

    private void logOrientationChange(int orientation) {
        if (orientation == 2) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Configuration Orientation Change: LANDSCAPE (" + orientation + ")");
        } else if (orientation == 1) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Configuration Orientation Change: PORTRAIT (" + orientation + ")");
        }
    }

    private void onOrientationChanged() {
        this.handleLostFocus();
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().stopped(new WeakReference<Activity>(this.curActivity));
        }
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().available(this.curActivity);
        }
        ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
        for (Map.Entry<String, OSSystemConditionController.OSSystemConditionObserver> entry : sSystemConditionObservers.entrySet()) {
            KeyboardListener keyboardListener = new KeyboardListener(this, entry.getValue(), entry.getKey());
            treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            sKeyboardListeners.put(entry.getKey(), keyboardListener);
        }
        this.handleFocus();
    }

    private void handleLostFocus() {
        this.focusHandlerThread.runRunnable(new AppFocusRunnable(new WeakReference<Activity>(this.curActivity)));
    }

    private void handleFocus() {
        if (this.focusHandlerThread.hasBackgrounded() || this.nextResumeIsFirstActivity) {
            this.nextResumeIsFirstActivity = false;
            this.focusHandlerThread.resetBackgroundState();
            OneSignal.onAppFocus();
        } else {
            this.focusHandlerThread.stopScheduledRunnable();
        }
    }

    void addSystemConditionObserver(String key, OSSystemConditionController.OSSystemConditionObserver systemConditionObserver) {
        if (this.curActivity != null) {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            KeyboardListener keyboardListener = new KeyboardListener(this, systemConditionObserver, key);
            treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            sKeyboardListeners.put(key, keyboardListener);
        }
        sSystemConditionObservers.put(key, systemConditionObserver);
    }

    @Override
    public void removeSystemConditionObserver(@NotNull String key, @NotNull KeyboardListener keyboardListener) {
        if (this.curActivity != null) {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            if (Build.VERSION.SDK_INT < 16) {
                treeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            } else {
                treeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            }
        }
        sKeyboardListeners.remove(key);
        sSystemConditionObservers.remove(key);
    }

    void addActivityAvailableListener(String key, ActivityAvailableListener activityAvailableListener) {
        sActivityAvailableListeners.put(key, activityAvailableListener);
        if (this.curActivity != null) {
            activityAvailableListener.available(this.curActivity);
        }
    }

    void removeActivityAvailableListener(String key) {
        sActivityAvailableListeners.remove(key);
    }

    public FocusHandlerThread getFocusHandlerThread() {
        return this.focusHandlerThread;
    }

    public Activity getCurActivity() {
        return this.curActivity;
    }

    public void setCurActivity(Activity activity) {
        this.curActivity = activity;
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().available(this.curActivity);
        }
        try {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            for (Map.Entry<String, OSSystemConditionController.OSSystemConditionObserver> entry : sSystemConditionObservers.entrySet()) {
                KeyboardListener keyboardListener = new KeyboardListener(this, entry.getValue(), entry.getKey());
                treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
                sKeyboardListeners.put(entry.getKey(), keyboardListener);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    void setNextResumeIsFirstActivity(boolean nextResumeIsFirstActivity) {
        this.nextResumeIsFirstActivity = nextResumeIsFirstActivity;
    }

    static class KeyboardListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final OSSystemConditionController.OSSystemConditionObserver observer;
        private final OSSystemConditionController.OSSystemConditionHandler systemConditionListener;
        private final String key;

        private KeyboardListener(OSSystemConditionController.OSSystemConditionHandler systemConditionListener, OSSystemConditionController.OSSystemConditionObserver observer, String key) {
            this.systemConditionListener = systemConditionListener;
            this.observer = observer;
            this.key = key;
        }

        public void onGlobalLayout() {
            boolean keyboardUp = OSViewUtils.isKeyboardUp(new WeakReference<Activity>(OneSignal.getCurrentActivity()));
            if (!keyboardUp) {
                this.systemConditionListener.removeSystemConditionObserver(this.key, this);
                this.observer.systemConditionChanged();
            }
        }
    }

    private static class AppFocusRunnable
    implements Runnable {
        private boolean backgrounded;
        private boolean completed;
        private WeakReference<Activity> activityWeakReference;

        public AppFocusRunnable(WeakReference<Activity> activityWeakReference) {
            this.activityWeakReference = activityWeakReference;
        }

        @Override
        public void run() {
            if (this.activityWeakReference.get() != null) {
                return;
            }
            this.backgrounded = true;
            OneSignal.onAppLostFocus();
            this.completed = true;
        }
    }

    static class FocusHandlerThread
    extends HandlerThread {
        private Handler mHandler;
        private AppFocusRunnable appFocusRunnable;

        FocusHandlerThread() {
            super("FocusHandlerThread");
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        Looper getHandlerLooper() {
            return this.mHandler.getLooper();
        }

        void resetBackgroundState() {
            if (this.appFocusRunnable != null) {
                this.appFocusRunnable.backgrounded = false;
            }
        }

        void stopScheduledRunnable() {
            this.mHandler.removeCallbacksAndMessages(null);
        }

        void runRunnable(AppFocusRunnable runnable) {
            if (this.appFocusRunnable != null && this.appFocusRunnable.backgrounded && !this.appFocusRunnable.completed) {
                return;
            }
            this.appFocusRunnable = runnable;
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed((Runnable)runnable, 2000L);
        }

        boolean hasBackgrounded() {
            return this.appFocusRunnable != null && this.appFocusRunnable.backgrounded;
        }
    }

    static abstract class ActivityAvailableListener {
        ActivityAvailableListener() {
        }

        void available(@NonNull Activity activity) {
        }

        void stopped(WeakReference<Activity> reference) {
        }
    }
}

