/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2;

import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.exception.XMLEntityException;
import com.onelogin.saml2.logout.LogoutRequest;
import com.onelogin.saml2.logout.LogoutResponse;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import com.onelogin.saml2.util.Constants;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth {
    private static final Logger LOGGER = LoggerFactory.getLogger(Auth.class);
    private Saml2Settings settings;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String nameid;
    private String sessionIndex;
    private DateTime sessionExpiration;
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private boolean authenticated = false;
    private List<String> errors = new ArrayList<String>();
    private String errorReason;
    private String lastRequestId;

    public Auth() throws IOException, SettingsException {
        this(new SettingsBuilder().fromFile("onelogin.saml.properties").build(), null, null);
    }

    public Auth(String filename) throws IOException, SettingsException {
        this(new SettingsBuilder().fromFile(filename).build(), null, null);
    }

    public Auth(HttpServletRequest request, HttpServletResponse response) throws IOException, SettingsException {
        this(new SettingsBuilder().fromFile("onelogin.saml.properties").build(), request, response);
    }

    public Auth(String filename, HttpServletRequest request, HttpServletResponse response) throws SettingsException, IOException {
        this(new SettingsBuilder().fromFile(filename).build(), request, response);
    }

    public Auth(Saml2Settings settings, HttpServletRequest request, HttpServletResponse response) throws SettingsException {
        this.settings = settings;
        this.request = request;
        this.response = response;
        List<String> settingsErrors = settings.checkSettings();
        if (!settingsErrors.isEmpty()) {
            String errorMsg = "Invalid settings: ";
            errorMsg = errorMsg + StringUtils.join(settingsErrors, (String)", ");
            LOGGER.debug(errorMsg);
            throw new SettingsException(errorMsg);
        }
        LOGGER.debug("Settings validated");
    }

    public void setStrict(Boolean value) {
        this.settings.setStrict(value);
    }

    public void login(String returnTo, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        AuthnRequest authnRequest = new AuthnRequest(this.settings, forceAuthn, isPassive, setNameIdPolicy);
        String samlRequest = authnRequest.getEncodedAuthnRequest();
        parameters.put("SAMLRequest", samlRequest);
        String relayState = returnTo == null ? Util.getSelfRoutedURLNoQuery(this.request) : returnTo;
        parameters.put("RelayState", relayState);
        if (this.settings.getAuthnRequestsSigned().booleanValue()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildRequestSignature(samlRequest, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String ssoUrl = this.getSSOurl();
        LOGGER.debug("AuthNRequest sent to " + ssoUrl + " --> " + samlRequest);
        Util.sendRedirect(this.response, ssoUrl, parameters);
        this.lastRequestId = authnRequest.getId();
    }

    public void login() throws IOException {
        this.login(null, false, false, true);
    }

    public void login(String returnTo) throws IOException {
        this.login(returnTo, false, false, true);
    }

    public void logout(String returnTo, String nameId, String sessionIndex) throws IOException, XMLEntityException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        LogoutRequest logoutRequest = new LogoutRequest(this.settings, null, nameId, sessionIndex);
        String samlLogoutRequest = logoutRequest.getEncodedLogoutRequest();
        parameters.put("SAMLRequest", samlLogoutRequest);
        String relayState = returnTo == null || returnTo.isEmpty() ? Util.getSelfRoutedURLNoQuery(this.request) : returnTo;
        parameters.put("RelayState", relayState);
        if (this.settings.getLogoutRequestSigned().booleanValue()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildRequestSignature(samlLogoutRequest, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String sloUrl = this.getSLOurl();
        LOGGER.debug("Logout request sent to " + sloUrl + " --> " + samlLogoutRequest);
        Util.sendRedirect(this.response, sloUrl, parameters);
        this.lastRequestId = logoutRequest.getId();
    }

    public void logout() throws IOException, XMLEntityException {
        this.logout(null, null, null);
    }

    public void logout(String returnTo) throws IOException, XMLEntityException {
        this.logout(returnTo, null, null);
    }

    public String getSSOurl() {
        return this.settings.getIdpSingleSignOnServiceUrl().toString();
    }

    public String getSLOurl() {
        return this.settings.getIdpSingleLogoutServiceUrl().toString();
    }

    public void processResponse(String requestId) throws Exception {
        this.authenticated = false;
        String samlResponseParameter = this.request.getParameter("SAMLResponse");
        if (samlResponseParameter != null) {
            SamlResponse samlResponse = new SamlResponse(this.settings, this.request);
            if (samlResponse.isValid(requestId)) {
                this.nameid = samlResponse.getNameId();
                this.authenticated = true;
                this.attributes = samlResponse.getAttributes();
                this.sessionIndex = samlResponse.getSessionIndex();
                this.sessionExpiration = samlResponse.getSessionNotOnOrAfter();
                LOGGER.debug("processResponse success --> " + samlResponseParameter);
            } else {
                this.errors.add("invalid_response");
                LOGGER.error("processResponse error. invalid_response");
                LOGGER.debug(" --> " + samlResponseParameter);
                this.errorReason = samlResponse.getError();
            }
        } else {
            this.errors.add("invalid_binding");
            String errorMsg = "SAML Response not found, Only supported HTTP_POST Binding";
            LOGGER.error("processResponse error." + errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public void processResponse() throws Exception {
        this.processResponse(null);
    }

    public void processSLO(Boolean keepLocalSession, String requestId) throws Exception {
        String samlRequestParameter = this.request.getParameter("SAMLRequest");
        String samlResponseParameter = this.request.getParameter("SAMLResponse");
        if (samlResponseParameter != null) {
            LogoutResponse logoutResponse = new LogoutResponse(this.settings, this.request);
            if (!logoutResponse.isValid(requestId).booleanValue()) {
                this.errors.add("invalid_logout_response");
                LOGGER.error("processSLO error. invalid_logout_response");
                LOGGER.debug(" --> " + samlResponseParameter);
                this.errorReason = logoutResponse.getError();
            } else {
                String status = logoutResponse.getStatus();
                if (status == null || !status.equals(Constants.STATUS_SUCCESS)) {
                    this.errors.add("logout_not_success");
                    LOGGER.error("processSLO error. logout_not_success");
                    LOGGER.debug(" --> " + samlResponseParameter);
                } else {
                    LOGGER.debug("processSLO success --> " + samlResponseParameter);
                    if (!keepLocalSession.booleanValue()) {
                        this.request.getSession().invalidate();
                    }
                }
            }
        } else if (samlRequestParameter != null) {
            LogoutRequest logoutRequest = new LogoutRequest(this.settings, this.request);
            if (!logoutRequest.isValid().booleanValue()) {
                this.errors.add("invalid_logout_request");
                LOGGER.error("processSLO error. invalid_logout_request");
                LOGGER.debug(" --> " + samlRequestParameter);
                this.errorReason = logoutRequest.getError();
            } else {
                LOGGER.debug("processSLO success --> " + samlRequestParameter);
                if (!keepLocalSession.booleanValue()) {
                    this.request.getSession().invalidate();
                }
                String inResponseTo = logoutRequest.id;
                LogoutResponse logoutResponseBuilder = new LogoutResponse(this.settings, this.request);
                logoutResponseBuilder.build(inResponseTo);
                String samlLogoutResponse = logoutResponseBuilder.getEncodedLogoutResponse();
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("SAMLResponse", samlLogoutResponse);
                String relayState = this.request.getParameter("RelayState");
                if (relayState != null) {
                    parameters.put("RelayState", relayState);
                }
                if (this.settings.getLogoutRequestSigned().booleanValue()) {
                    String sigAlg = this.settings.getSignatureAlgorithm();
                    String signature = this.buildResponseSignature(samlLogoutResponse, relayState, sigAlg);
                    parameters.put("SigAlg", sigAlg);
                    parameters.put("Signature", signature);
                }
                String sloUrl = this.getSLOurl();
                LOGGER.debug("Logout response sent to " + sloUrl + " --> " + samlLogoutResponse);
                Util.sendRedirect(this.response, sloUrl, parameters);
            }
        } else {
            this.errors.add("invalid_binding");
            String errorMsg = "SAML LogoutRequest/LogoutResponse not found. Only supported HTTP_REDIRECT Binding";
            LOGGER.error("processSLO error." + errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public void processSLO() throws Exception {
        this.processSLO(false, null);
    }

    public final boolean isAuthenticated() {
        return this.authenticated;
    }

    public final List<String> getAttributesName() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public final Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public final Collection<String> getAttribute(String name) {
        return this.attributes.get(name);
    }

    public final String getNameId() {
        return this.nameid;
    }

    public final String getSessionIndex() {
        return this.sessionIndex;
    }

    public final DateTime getSessionExpiration() {
        return this.sessionExpiration;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String getLastErrorReason() {
        return this.errorReason;
    }

    public String getLastRequestId() {
        return this.lastRequestId;
    }

    public Saml2Settings getSettings() {
        return this.settings;
    }

    public Boolean isDebugActive() {
        return this.settings.isDebugActive();
    }

    public String buildRequestSignature(String samlRequest, String relayState, String signAlgorithm) {
        return this.buildSignature(samlRequest, relayState, signAlgorithm, "SAMLRequest");
    }

    public String buildResponseSignature(String samlResponse, String relayState, String signAlgorithm) {
        return this.buildSignature(samlResponse, relayState, signAlgorithm, "SAMLResponse");
    }

    private String buildSignature(String samlMessage, String relayState, String signAlgorithm, String type) {
        String signature = "";
        if (!this.settings.checkSPCerts().booleanValue()) {
            String errorMsg = "Trying to sign the " + type + " but can't load the SP certs";
            LOGGER.error("buildSignature error. " + errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        PrivateKey key = this.settings.getSPkey();
        String msg = type + "=" + Util.urlEncoder(samlMessage);
        if (relayState != null) {
            msg = msg + "&RelayState=" + Util.urlEncoder(relayState);
        }
        if (signAlgorithm == null || signAlgorithm.isEmpty()) {
            signAlgorithm = Constants.RSA_SHA1;
        }
        msg = msg + "&SigAlg=" + Util.urlEncoder(signAlgorithm);
        try {
            signature = Util.base64encoder(Util.sign(msg, key, signAlgorithm));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            LOGGER.error("buildSignature error." + e.getMessage());
        }
        if (signature.isEmpty()) {
            String errorMsg = "There was a problem when calculating the Signature of the " + type;
            LOGGER.error("buildSignature error. " + errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        LOGGER.debug("buildResponseSignature success. --> " + signature);
        return signature;
    }
}

